/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.factory;

import de.bscgmbh.iroom.api.command.AbstractCommand;
import de.bscgmbh.iroom.api.command.CommandBeep;
import de.bscgmbh.iroom.api.command.CommandIDock;
import de.bscgmbh.iroom.api.command.CommandLed0;
import de.bscgmbh.iroom.api.command.CommandLed1;
import de.bscgmbh.iroom.api.command.CommandLed2;
import de.bscgmbh.iroom.api.command.CommandLed3;
import de.bscgmbh.iroom.api.command.CommandLed4;
import de.bscgmbh.iroom.api.command.CommandLed5;
import de.bscgmbh.iroom.api.command.CommandLed6;
import de.bscgmbh.iroom.api.command.CommandLed7;
import de.bscgmbh.iroom.api.command.CommandLed8;
import de.bscgmbh.iroom.api.command.CommandMusic;
import de.bscgmbh.iroom.api.command.CommandRelay0;
import de.bscgmbh.iroom.api.command.CommandVolume;
import de.bscgmbh.iroom.api.data.parameter.IIRoomParameterVO;
import de.bscgmbh.iroom.api.data.types.CommandEnum;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;

public class CommandFactory {
    public static AbstractCommand getCommand(String command, String parameter) {
        if (command == null) {
            return null;
        }
        CommandEnum commandEnum = CommandEnum.fromApiShortcutDescription(command);
        if (commandEnum == null) {
            return null;
        }
        Object state = commandEnum.getIIRoomParameterVO().parseValue(parameter);
        if (state != null) {
            return CommandFactory.getCommand(commandEnum, state);
        }
        return null;
    }

    public static AbstractCommand getCommand(CommandEnum commandEnum, Comparable<?> state) {
        try {
            switch (commandEnum) {
                case BEEP: {
                    return new CommandBeep((Double)state);
                }
                case DOCK: {
                    return new CommandIDock((StateValueEnum)((Object)state));
                }
                case LED_0: {
                    return new CommandLed0((Integer)state);
                }
                case LED_1: {
                    return new CommandLed1((Integer)state);
                }
                case LED_2: {
                    return new CommandLed2((Integer)state);
                }
                case LED_3: {
                    return new CommandLed3((Integer)state);
                }
                case LED_4: {
                    return new CommandLed4((Integer)state);
                }
                case LED_5: {
                    return new CommandLed5((Integer)state);
                }
                case LED_6: {
                    return new CommandLed6((Integer)state);
                }
                case LED_7: {
                    return new CommandLed7((Integer)state);
                }
                case LED_8: {
                    return new CommandLed8((Integer)state);
                }
                case RELAY_0: {
                    return new CommandRelay0((StateValueEnum)((Object)state));
                }
                case VOLUME_CONTROL: {
                    return new CommandVolume((Integer)state);
                }
                case MUSIC_CONTROL: {
                    return new CommandMusic((StateValueEnum)((Object)state));
                }
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AbstractCommand getCommand(CommandEnum commandEnum, IIRoomParameterVO<?> iRoomParameterVO) {
        return CommandFactory.getCommand(commandEnum, iRoomParameterVO.getIValueWithRange().getCurrentValue());
    }

    public static void main(String[] args) {
        for (CommandEnum command : CommandEnum.values()) {
            System.out.println("case " + command + ":\nreturn ;");
        }
    }
}

