/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.data;

import de.bscgmbh.iroom.api.data.parameter.IRoomParameterDouble;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterInteger;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterStateValueEnum;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueNumber;
import de.bscgmbh.iroom.utils.range.DoubleRange;
import de.bscgmbh.iroom.utils.range.EnumRange;
import de.bscgmbh.iroom.utils.range.IntegerRange;
import de.bscgmbh.iroom.utils.range.UnitEnum;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultIRoomParameterVOCreator {
    public static IRoomParameterInteger createIRoomParameterInteger(Integer defaultValue, Integer rangeMin, Integer rangeMax, UnitEnum unit) {
        return new IRoomParameterInteger(new CurrentValueNumber<Integer>(defaultValue, new IntegerRange(rangeMin, rangeMax), unit));
    }

    public static IRoomParameterInteger createIRoomParameterInteger(Integer defaultValue, Integer rangeMin, Integer rangeMax) {
        return new IRoomParameterInteger(new CurrentValueNumber<Integer>(defaultValue, new IntegerRange(rangeMin, rangeMax)));
    }

    public static IRoomParameterDouble createIRoomParameterrDouble(Double defaultValue, Double rangeMin, Double rangeMax, UnitEnum unit) {
        return new IRoomParameterDouble(new CurrentValueNumber<Double>(defaultValue, new DoubleRange(rangeMin, rangeMax), unit));
    }

    public static IRoomParameterDouble createIRoomParameterDouble(Double defaultValue, Double rangeMin, Double rangeMax) {
        return new IRoomParameterDouble(new CurrentValueNumber<Double>(defaultValue, new DoubleRange(rangeMin, rangeMax)));
    }

    public static IRoomParameterStateValueEnum createIRoomParameterStateValueEnum(StateValueEnum defaultValue, Set<StateValueEnum> stateValueEnums, UnitEnum unit) {
        return new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(defaultValue, new EnumRange<StateValueEnum>(stateValueEnums), unit));
    }

    public static IRoomParameterStateValueEnum createIRoomParameterStateValueEnum(StateValueEnum defaultValue, UnitEnum unit, StateValueEnum ... stateValueEnums) {
        return new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(defaultValue, new EnumRange<StateValueEnum>(new LinkedHashSet<StateValueEnum>(Arrays.asList(stateValueEnums))), unit));
    }

    public static IRoomParameterStateValueEnum createIRoomParameterStateValueEnum(StateValueEnum defaultValue, Set<StateValueEnum> stateValueEnums) {
        return new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(defaultValue, new EnumRange<StateValueEnum>(stateValueEnums)));
    }

    public static IRoomParameterStateValueEnum createIRoomParameterStateValueEnum(StateValueEnum defaultValue, StateValueEnum ... stateValueEnums) {
        return new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(defaultValue, new EnumRange<StateValueEnum>(new LinkedHashSet<StateValueEnum>(Arrays.asList(stateValueEnums)))));
    }
}

