/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static Logger logger = LoggerFactory.getLogger(Validator.class);

    public static void printRegisteredArguments() {
        logger.debug("===================================");
        logger.debug("Currently Registered Arguments Are:");
        logger.debug("===================================");
        for (Argument a : Argument.values()) {
            logger.debug(a.toString());
        }
        logger.debug("===================================");
    }

    private static Argument getRegisteredArgument(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must nor be null");
        }
        if (!parameter.startsWith("-")) {
            return null;
        }
        while ((parameter = parameter.substring(1, parameter.length())).startsWith("-")) {
        }
        for (Argument a : Argument.values()) {
            if (!a.doesAnswerWhenCalled(parameter)) continue;
            return a;
        }
        return null;
    }

    public static Argument get(Argument arg, String[] args) {
        if (arg == null || args == null) {
            throw new IllegalArgumentException("neither the String array 'args' nor the given Argument 'arg' are allowed to be null");
        }
        for (int i = 0; i < args.length; ++i) {
            String parameter = args[i];
            Argument a = Validator.getRegisteredArgument(parameter);
            if (a == null || a != arg) continue;
            if (a.takesFollowArgument) {
                if (i + 1 < args.length) {
                    String followUp = args[i + 1];
                    a.value = followUp;
                    return a;
                }
                throw new IllegalArgumentException("argument that needs follow up argument has none. {" + (Object)((Object)a) + "}");
            }
            return a;
        }
        return null;
    }

    public static enum Argument {
        SERVER("server", "s"),
        PORT("port", "o"),
        USER("user", "u"),
        PASS("pass", "p"),
        CLEAN_START("clean", "c", false),
        MAX_CONNECTION("maxcon", "m"),
        ASYNCHRONOUS_CONNECTION("async", "a", false),
        WEBSOCKET("websocket", "w", false),
        M2M_SERVER("m2mserver", "e"),
        M2M_CONNECT_ID("m2mconnectid", "n"),
        SIMULATION("simulation", "sim"),
        BOSE("bose", "b", false);

        private String name;
        private String alias;
        private String value;
        private boolean takesFollowArgument;

        private Argument(String name, String alias) {
            this(name, alias, true);
        }

        private Argument(String name, String alias, boolean takesFollowArgument) {
            this.name = name;
            this.alias = alias;
            this.takesFollowArgument = takesFollowArgument;
        }

        public String getValue() {
            return this.value;
        }

        public boolean doesAnswerWhenCalled(String parameterOrAlias) {
            return parameterOrAlias.equals(this.name) || parameterOrAlias.equals(this.alias);
        }

        public String toString() {
            return String.format("--%s(-%s)", this.name, this.alias);
        }
    }
}

