/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tools3 {
    private static Logger logger = LoggerFactory.getLogger(Tools3.class);
    private static boolean initialized = false;
    private static ObjectCreator objectCreator;
    private static final char[] digits;

    public static void init(String packageCodePath) {
        String vm = System.getProperty("java.vm.vendor");
        if (vm != null && vm.contains("Oracle")) {
            return;
        }
        objectCreator = ObjectCreator.create(packageCodePath);
        initialized = true;
    }

    public static <T> T getInstance(Class<T> c) throws UnsupportedOperationException {
        try {
            return objectCreator.newInstance(c);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{digits[value >>> 4 & 0xF], digits[value & 0xF]};
        return new String(chars);
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(Tools3.toHexString(data[i]));
        }
        return buffer.toString();
    }

    public static byte[] getBytes(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface) {
        return Tools3.getClasses(packageName, requiredInterface, true);
    }

    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface, boolean subPackages) {
        Class<?>[] classes = Tools3.getClasses(packageName, subPackages);
        ArrayList<Class<T>> tmpClasses = new ArrayList<Class<T>>();
        if (classes == null) {
            return tmpClasses;
        }
        for (Class<?> clazz : classes) {
            if (!requiredInterface.isAssignableFrom(clazz)) continue;
            tmpClasses.add(clazz);
        }
        return tmpClasses;
    }

    public static Class<?>[] getClasses(String packageName, boolean subPackages) {
        return objectCreator.getClasses(packageName, subPackages);
    }

    private static List<Class<?>> findClasses(URL url, String packageName, boolean subPackages) {
        packageName = packageName.replace('.', '/');
        JarURLConnection connection = null;
        ArrayList classes = new ArrayList();
        try {
            connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int index;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(packageName) || !name.contains(".class") || !subPackages && !packageName.equals(name.substring(0, index = name.lastIndexOf("/")))) continue;
                name = name.substring(0, name.indexOf(46));
                name = name.replace('/', '.');
                try {
                    classes.add(Class.forName(name));
                }
                catch (Throwable e) {
                    logger.error("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName, boolean subPackages) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory() && subPackages) {
                assert (!file.getName().contains("."));
                classes.addAll(Tools3.findClasses(file, packageName + "." + file.getName(), subPackages));
                continue;
            }
            if (!file.getName().contains(".class")) continue;
            String name = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            if (name.startsWith(".")) {
                name = name.substring(1);
            }
            try {
                classes.add(Class.forName(name));
            }
            catch (Throwable e) {
                logger.error("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage(), e);
            }
        }
        return classes;
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        int length = 0;
        StringBuffer stringBuffer = new StringBuffer();
        length = dataInputStream.readInt();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(dataInputStream.readChar());
        }
        return stringBuffer.toString();
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (dataOutputStream == null) {
            return;
        }
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        }
    }

    public static Enum<?> getFirstMatchingEnum(Class<? extends Enum<?>> toMatch, Set<Enum<?>> eList) {
        Set<Enum<?>> enums = Tools3.findMatchingEnums(toMatch, eList);
        if (!enums.isEmpty()) {
            return enums.toArray(new Enum[enums.size()])[0];
        }
        return null;
    }

    public static Set<Enum<?>> findMatchingEnums(Class<? extends Enum<?>> toMatch, Set<Enum<?>> eList) {
        HashSet set = new HashSet();
        for (Enum<?> e : eList) {
            if (!toMatch.isInstance(e)) continue;
            set.add(e);
        }
        return set;
    }

    static {
        if (!initialized) {
            objectCreator = ObjectCreator.create(System.getProperty("java.vm.vendor"));
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static abstract class ObjectCreator {
        private ObjectCreator() {
        }

        public abstract <T> T newInstance(Class<T> var1) throws Exception;

        public abstract Class<?>[] getClasses(String var1, boolean var2);

        public static ObjectCreator create(String packageCodePath) {
            if (packageCodePath != null) {
                try {
                    final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    assert (classLoader != null);
                    if (packageCodePath.contains("Oracle")) {
                        Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                        Field f = unsafeClass.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        final Object unsafe = f.get(null);
                        final Method allocateInstance = unsafeClass.getMethod("allocateInstance", Class.class);
                        return new ObjectCreator(){

                            @Override
                            public <T> T newInstance(Class<T> c) throws Exception {
                                return (T)allocateInstance.invoke(unsafe, c);
                            }

                            @Override
                            public Class<?>[] getClasses(String packageName, boolean subPackages) {
                                String path = packageName.replace('.', '/');
                                URL resource = classLoader.getResource(path);
                                ArrayList classes = new ArrayList();
                                if (resource != null) {
                                    ArrayList<File> dirs = new ArrayList<File>();
                                    ArrayList<URL> urls = new ArrayList<URL>();
                                    if (!resource.toString().contains("!")) {
                                        dirs.add(new File(resource.getFile()));
                                    } else {
                                        urls.add(resource);
                                    }
                                    for (File directory : dirs) {
                                        try {
                                            classes.addAll(Tools3.findClasses(directory, packageName, subPackages));
                                        }
                                        catch (ClassNotFoundException e) {}
                                    }
                                    for (URL url : urls) {
                                        classes.addAll(Tools3.findClasses(url, packageName, subPackages));
                                    }
                                }
                                return classes.toArray(new Class[classes.size()]);
                            }
                        };
                    }
                    if (packageCodePath.contains("apk")) {
                        Class<?> c = classLoader.loadClass("dalvik.system.DexFile");
                        Constructor<?> con = c.getConstructor(String.class);
                        final Object dexFile = con.newInstance(packageCodePath);
                        final Method entries = dexFile.getClass().getMethod("entries", new Class[0]);
                        Class<?> version = classLoader.loadClass("android.os.Build$VERSION");
                        Field sdkInt = version.getField("SDK_INT");
                        int sdk = (Integer)sdkInt.get(null);
                        if (sdk < 9) {
                            final Method newInstance = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                            newInstance.setAccessible(true);
                            return new ObjectCreator(){

                                @Override
                                public <T> T newInstance(Class<T> c) throws Exception {
                                    return (T)newInstance.invoke(null, c, Object.class);
                                }

                                @Override
                                public Class<?>[] getClasses(String packageName, boolean subPackages) {
                                    ArrayList classes = new ArrayList();
                                    try {
                                        Enumeration enums;
                                        Enumeration iter = enums = (Enumeration)entries.invoke(dexFile, new Object[0]);
                                        while (iter.hasMoreElements()) {
                                            String className = (String)iter.nextElement();
                                            if (!className.contains(packageName)) continue;
                                            Class<?> clazz = classLoader.loadClass(className);
                                            classes.add(clazz);
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.error(e.getMessage(), (Throwable)e);
                                    }
                                    return classes.toArray(new Class[classes.size()]);
                                }
                            };
                        }
                        Method getConstructorId = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                        getConstructorId.setAccessible(true);
                        final long constructorId = (Long)getConstructorId.invoke(null, Object.class);
                        final Method newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Long.TYPE);
                        newInstance.setAccessible(true);
                        return new ObjectCreator(){

                            @Override
                            public <T> T newInstance(Class<T> c) throws Exception {
                                return (T)newInstance.invoke(null, c, constructorId);
                            }

                            @Override
                            public Class<?>[] getClasses(String packageName, boolean subPackages) {
                                ArrayList classes = new ArrayList();
                                try {
                                    Enumeration enums;
                                    Enumeration iter = enums = (Enumeration)entries.invoke(dexFile, new Object[0]);
                                    while (iter.hasMoreElements()) {
                                        String className = (String)iter.nextElement();
                                        if (!className.contains(packageName)) continue;
                                        Class<?> clazz = classLoader.loadClass(className);
                                        classes.add(clazz);
                                    }
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                                return classes.toArray(new Class[classes.size()]);
                            }
                        };
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return new ObjectCreator(){

                @Override
                public <T> T newInstance(Class<T> c) {
                    throw new UnsupportedOperationException("Unable to create an object of class " + c);
                }

                @Override
                public Class<?>[] getClasses(String packageName, boolean subPackages) {
                    throw new IllegalArgumentException("Unable to get classes of UNKNOWN platform.");
                }
            };
        }
    }
}

