/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools;

import bsc.api.modules.core.model.Group;
import bsc.sdk.tools.creator.AObjectCreator;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Tools {
    private static boolean initialized = false;
    private static int counter = 0;
    private static AObjectCreator objectCreator;
    private static final char[] digits;

    public static void init(String packageCodePath) {
        String vm = System.getProperty("java.vm.vendor");
        if (vm != null && vm.contains("Oracle")) {
            return;
        }
        objectCreator = AObjectCreator.create(packageCodePath);
        initialized = true;
    }

    public static void setObjectCreator(AObjectCreator objectCreator) {
        Tools.objectCreator = objectCreator;
    }

    public static <T> T getInstance(Class<T> c) throws UnsupportedOperationException {
        try {
            return objectCreator.newInstance(c);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static int countUp() {
        return ++counter;
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{digits[value >>> 4 & 0xF], digits[value & 0xF]};
        return new String(chars);
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(Tools.toHexString(data[i]));
        }
        return buffer.toString();
    }

    public static byte[] getBytes(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return new byte[0];
        }
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            stream.write(Integer.parseInt(hexString.substring(i, i + 2), 16));
        }
        return stream.toByteArray();
    }

    public static byte[] getBytes(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] getBytes(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface) {
        return Tools.getClasses(packageName, requiredInterface, true);
    }

    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface, boolean subPackages) {
        Class<?>[] classes = Tools.getClasses(packageName, subPackages);
        ArrayList<Class<T>> tmpClasses = new ArrayList<Class<T>>();
        if (classes == null) {
            return tmpClasses;
        }
        for (Class<?> clazz : classes) {
            if (!requiredInterface.isAssignableFrom(clazz)) continue;
            tmpClasses.add(clazz);
        }
        return tmpClasses;
    }

    public static Class<?>[] getClasses(String packageName, boolean subPackages) {
        return objectCreator.getClasses(packageName, subPackages);
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        int length = 0;
        StringBuffer stringBuffer = new StringBuffer();
        length = dataInputStream.readInt();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(dataInputStream.readChar());
        }
        return stringBuffer.toString();
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (dataOutputStream == null) {
            return;
        }
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        }
    }

    public static Enum<?> getFirstMatchingEnum(Class<? extends Enum<?>> toMatch, Set<Enum<?>> eList) {
        Set<Enum<?>> enums = Tools.findMatchingEnums(toMatch, eList);
        if (!enums.isEmpty()) {
            return enums.toArray(new Enum[enums.size()])[0];
        }
        return null;
    }

    public static Set<Enum<?>> findMatchingEnums(Class<? extends Enum<?>> toMatch, Set<Enum<?>> eList) {
        HashSet set = new HashSet();
        for (Enum<?> e : eList) {
            if (!toMatch.isInstance(e)) continue;
            set.add(e);
        }
        return set;
    }

    public static <T> T deepClone(T object) {
        return objectCreator.deepClone(object);
    }

    public static Type[] getActualTypeArguments(String name) {
        if (!name.contains("$$006")) {
            return new Class[0];
        }
        String[] parts = name.split("\\$+");
        Type[] classes = new Class[parts.length - 3];
        for (int i = 2; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.startsWith("_L")) {
                part = part.substring(2, part.length() - 1).replace("__", ".");
                try {
                    classes[i - 2] = Tools.classForName(part);
                }
                catch (ClassNotFoundException e) {
                    classes[i - 2] = Object.class;
                }
                continue;
            }
            if (part.equals("_Z_")) {
                classes[i - 2] = Boolean.TYPE;
                continue;
            }
            if (part.equals("_B_")) {
                classes[i - 2] = Byte.TYPE;
                continue;
            }
            if (part.equals("_C_")) {
                classes[i - 2] = Character.TYPE;
                continue;
            }
            if (part.equals("_S_")) {
                classes[i - 2] = Short.TYPE;
                continue;
            }
            if (part.equals("_I_")) {
                classes[i - 2] = Integer.TYPE;
                continue;
            }
            if (part.equals("_J_")) {
                classes[i - 2] = Long.TYPE;
                continue;
            }
            if (part.equals("_F_")) {
                classes[i - 2] = Float.TYPE;
                continue;
            }
            if (!part.equals("_D_")) continue;
            classes[i - 2] = Double.TYPE;
        }
        return classes;
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return objectCreator.getClassForName(className);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static int getTopGroup(int groupID, Set<Group> availableGroups) {
        for (Group group : availableGroups) {
            if (group.getId() != groupID) continue;
            if (group.getParentID() == 0) {
                return group.getId();
            }
            return Tools.getTopGroup(group.getParentID(), availableGroups);
        }
        return groupID;
    }

    public static double scale(double value, double scaleFrom, double scaleTo, double start, double end) {
        double bandwidth = 0.0;
        double stepsize = 0.0;
        double byteregion = Math.abs(end - start);
        bandwidth = Math.abs(scaleTo - scaleFrom);
        stepsize = bandwidth / byteregion;
        value = start > end ? Math.max(Math.min(start, value), end) : Math.min(Math.max(start, value), end);
        value -= start;
        if (start > end) {
            value = start - value - start;
        }
        double result = value * stepsize;
        result = scaleFrom < scaleTo ? (result += scaleFrom) : scaleFrom - result;
        return result;
    }

    public static int getRandomNumberInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return new Random().nextInt(max - min + 1) + min;
    }

    public static boolean checkForOpenPort(int port) {
        return Tools.checkForOpenPort("localhost", port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkForOpenPort(String host, int port) {
        try (Socket ignored = new Socket(host, port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored2) {
            return false;
        }
    }

    static {
        if (!initialized) {
            objectCreator = AObjectCreator.create(System.getProperty("java.vm.vendor"));
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

