/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.net;

import bsc.sdk.net.ISocket;
import bsc.sdk.net.sockets.MobileSocket;
import bsc.sdk.net.sockets.WebSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketFactory {
    private static Logger logger = LoggerFactory.getLogger(SocketFactory.class);
    private static SocketFactory defaultFactory = null;

    public static SocketFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = SocketFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(SocketFactory factory) {
        defaultFactory = factory;
    }

    public static SocketFactory createDefaultFactory() {
        return new SocketFactory(){

            @Override
            public ISocket createMobileSocketInstance(Socket socket, InputStream inputStream, OutputStream outputStream) {
                return new MobileSocket(socket, inputStream, outputStream);
            }

            @Override
            public ISocket createWebSocketInstance(Socket socket, InputStream inputStream, OutputStream outputStream, String protocol) {
                try {
                    return WebSocket.createWebSocket(socket, inputStream, outputStream, protocol);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }

    public static ISocket createNewMobileInstance(Socket socket, InputStream inputStream, OutputStream outputStream) {
        return SocketFactory.createNewInstance(TYPE.MOBILE, socket, inputStream, outputStream);
    }

    public static ISocket createNewWebsocketInstance(Socket socket, InputStream inputStream, OutputStream outputStream) {
        return SocketFactory.createNewInstance(TYPE.WEBSOCKET, socket, inputStream, outputStream);
    }

    public static ISocket createNewInstance(TYPE type, Socket socket, InputStream inputStream, OutputStream outputStream) {
        if (type != null) {
            switch (type) {
                case WEBSOCKET: {
                    return SocketFactory.getDefaultFactory().createWebSocketInstance(socket, inputStream, outputStream, "bose");
                }
            }
            return SocketFactory.getDefaultFactory().createMobileSocketInstance(socket, inputStream, outputStream);
        }
        return null;
    }

    public abstract ISocket createMobileSocketInstance(Socket var1, InputStream var2, OutputStream var3);

    public abstract ISocket createWebSocketInstance(Socket var1, InputStream var2, OutputStream var3, String var4);

    public static enum TYPE {
        MOBILE,
        WEBSOCKET;

    }
}

