/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.server;

import bsc.api.Enumerations;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateExit;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;

public class StateError
extends AStateExit {
    private Throwable throwable;
    private String message;

    public StateError(StateConfiguration stateSettings) {
        super(stateSettings);
        this.throwable = stateSettings.getThrowable();
        this.message = stateSettings.getMessage();
        this.connector.transceiverStateChanged(TransceiverState.STATE.ERROR, null);
    }

    @Override
    public int getLevel() {
        return 3;
    }

    @Override
    public ITransceiverState execute() {
        TransceiverException transceiverException = this.throwable instanceof TransceiverException ? (TransceiverException)this.throwable : (this.throwable != null && this.message != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.message, this.throwable) : (this.message != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.message) : (this.throwable != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.throwable) : new TransceiverException(Enumerations.ErrorType.EXCEPTION))));
        this.connector.getTransceiver().error(transceiverException);
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.DISCONNECT, this.connector));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        return null;
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return this;
    }
}

