/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.server;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.model.Auth;
import bsc.api.transport.model.Settings;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.sdk.api.crypt.CipherFactory;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.session.ASessionFactory;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.SessionType;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateInit;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;
import bsc.sdk.security.Checksum;
import bsc.sdk.security.DHKey;
import bsc.sdk.tools.SimpleFileWriter;
import bsc.sdk.tools.Tools;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateAuth
extends AStateInit {
    private static Logger logger = LoggerFactory.getLogger(StateAuth.class);
    private static long connectionCount = 0L;
    private Settings settings;
    private boolean createSession = true;
    private Stage currentStage = Stage.DONE;

    public StateAuth(StateConfiguration stateSettings) {
        super(stateSettings);
        this.createSession = stateSettings.isCreateSession();
        this.settings = stateSettings.getSettings();
        this.currentStage = Stage.HANDLE_AUTH;
        this.setCapsMetaData(stateSettings.getMetaInformations());
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public ITransceiverState execute() {
        try {
            this.connector.transceiverStateChanged(TransceiverState.STATE.AUTH, this.currentStage.name());
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case HANDLE_AUTH: 
            }
            TransmissionObject transmissionObject = this.connector.getTransceiver().nextIncomingTransmission();
            Auth auth = (Auth)this.checkResult(transmissionObject, Auth.class);
            IUserCredential userCredential = this.connector.getUser();
            if (userCredential == null) {
                this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.NO_SUCH_USER, "No user credential")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                throw new TransceiverException(Enumerations.ErrorType.NO_SUCH_USER, "No such user \"" + auth.getUser() + "\"");
            }
            if (!userCredential.isActive()) {
                this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.USER_NOT_ACTIVATED, "User credential is not activated")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                throw new TransceiverException(Enumerations.ErrorType.USER_NOT_ACTIVATED, "User credential is not activated");
            }
            if (!this.connector.hasOpenConnectionSlots(userCredential.getUserName())) {
                this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.USER_ALREADY_CONNECTED, "User already connected")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                throw new TransceiverException(Enumerations.ErrorType.USER_ALREADY_CONNECTED, "User already connected");
            }
            byte[] sharedSecret = null;
            ICipher cipher = null;
            try {
                byte[] hash = Checksum.getSHA256Checksum(userCredential.getPassword().getBytes("UTF-8"));
                String passwordHash = Tools.toHexString(hash);
                String combined = userCredential.getUserName() + passwordHash;
                cipher = CipherFactory.createNewInstance(Enumerations.EncryptionType.AES);
                cipher.setShared(combined.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e);
            }
            byte[] A = auth.getKey();
            byte[] signatureA = auth.getSignature();
            byte[] checksumA1 = cipher.decrypt(signatureA);
            byte[] checksumA2 = Checksum.getSHA256Checksum(A);
            if (!Arrays.equals(checksumA1, checksumA2)) {
                this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), new FailResult(Enumerations.ErrorType.NOT_AUTHENTICATED, "Wrong password or message manipulated")), ChannelWorker.WriteMode.JSON_PROTOCOL);
                throw new TransceiverException(Enumerations.ErrorType.NOT_AUTHENTICATED, "Wrong password or message manipulated");
            }
            DHKey.BitSize size = auth.getBitSize() == null ? DHKey.BitSize.SIZE_2048 : DHKey.BitSize.SIZE_1024;
            BigInteger b = DHKey.genertateRandom(new SecureRandom(), size);
            BigInteger B = DHKey.genertatePublic(b, size);
            BigInteger shared = DHKey.genertateShared(new BigInteger(1, A), b, size);
            String sharedSecretString = shared.toString(16);
            sharedSecret = Tools.getBytes(sharedSecretString);
            String sessionID = this.connector.getNewSessionID();
            ISession session = ASessionFactory.createNewInstance(sessionID);
            session.setTimestamp(System.currentTimeMillis());
            session.setLastUsedTimestamp(System.currentTimeMillis());
            session.setUserCredentialID(userCredential.getUserName());
            session.setSharedSecret(sharedSecret);
            session.setApiVersion(this.settings.getApiVersion());
            session.setCompressionType(this.settings.getCompression());
            session.setEncryptionType(this.settings.getEncryption());
            session.setProtocolType(this.settings.getProtocol());
            session.setApiExtensions(this.settings.getApiExtensions());
            session.setCapsMetaData(this.getCapsMetaData());
            if (this.createSession) {
                session.setType(SessionType.PUBLIC);
            }
            this.connector.objectUpdated(session);
            this.connector.getTransceiver().initialize(sessionID);
            byte[] publicKey = B.toByteArray();
            byte[] checksum = Checksum.getSHA256Checksum(publicKey);
            byte[] signature = cipher.encrypt(checksum);
            ObjectResult result = this.createSession ? new ObjectResult(new Auth(auth.getUser(), publicKey, signature, session.getSessionID())) : new ObjectResult(new Auth(auth.getUser(), publicKey, signature));
            this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), result), ChannelWorker.WriteMode.JSON_PROTOCOL);
            if (this.createSession) {
                userCredential.setLastSessionID(session.getSessionID());
                this.connector.objectUpdated(userCredential);
            }
            this.currentStage = Stage.DONE;
            return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.WORK, this.connector));
        }
        catch (TransceiverException e) {
            return this.error(e);
        }
    }

    private void logData(byte[] sharedSecret, byte[] A, BigInteger B, BigInteger b) {
        String count = String.valueOf(++connectionCount);
        String log = "\r\n";
        log = log + "---- Connection: " + count + " ----" + "\r\n";
        log = log + "sharedSecret:   \r\n";
        log = log + Tools.toHexString(sharedSecret) + "\r\n";
        log = log + "\r\n";
        log = log + "client PubKey:  \r\n";
        log = log + Tools.toHexString(A) + "\r\n";
        log = log + "\r\n";
        log = log + "server PubKey:  \r\n";
        log = log + Tools.toHexString(B.toByteArray()) + "\r\n";
        log = log + "\r\n";
        log = log + "server PrivKey: \r\n";
        log = log + Tools.toHexString(b.toByteArray()) + "\r\n";
        log = log + "--------------------------\r\n";
        SimpleFileWriter.writeTo(StateAuth.class.getName() + ".txt", log);
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.DISCONNECT, this.connector));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.ERROR, this.connector));
    }

    private static enum Stage {
        HANDLE_AUTH,
        DONE;

    }
}

