/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.client;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.model.Auth;
import bsc.api.transport.model.Settings;
import bsc.sdk.api.crypt.CipherFactory;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateInit;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;
import bsc.sdk.security.Checksum;
import bsc.sdk.security.DHKey;
import bsc.sdk.tools.SimpleFileWriter;
import bsc.sdk.tools.Tools;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateAuth
extends AStateInit {
    private static Logger logger = LoggerFactory.getLogger(StateAuth.class);
    private ISession session;
    private Settings settings;
    private BigInteger a;
    private Stage currentStage = Stage.DONE;

    public StateAuth(StateConfiguration stateSettings) {
        super(stateSettings);
        this.session = stateSettings.getSession();
        this.currentStage = Stage.SENDING_AUTHENTICATION;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public ITransceiverState execute() {
        try {
            this.connector.getTransceiver().transceiverStateChanged(TransceiverState.STATE.AUTH, this.currentStage.name());
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case SENDING_AUTHENTICATION: {
                    ICipher cipher;
                    TransmissionObject transmissionObject = this.connector.getTransceiver().nextIncomingTransmission();
                    this.settings = (Settings)this.checkResult(transmissionObject, Settings.class);
                    IUserCredential userCredential = this.connector.getUser();
                    try {
                        String password = userCredential.getPassword();
                        byte[] hash = Checksum.getSHA256Checksum(password.getBytes("UTF-8"));
                        String passwordHash = Tools.toHexString(hash);
                        String combined = userCredential.getUserName() + passwordHash;
                        cipher = CipherFactory.createNewInstance(Enumerations.EncryptionType.AES);
                        cipher.setShared(combined.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e);
                    }
                    this.a = DHKey.genertateRandom(new SecureRandom(), DHKey.BitSize.SIZE_2048);
                    BigInteger A = DHKey.genertatePublic(this.a, DHKey.BitSize.SIZE_2048);
                    byte[] publicKey = A.toByteArray();
                    byte[] checksum = Checksum.getSHA256Checksum(publicKey);
                    byte[] signature = cipher.encrypt(checksum);
                    Auth auth = new Auth(userCredential.getUserName(), publicKey, signature);
                    this.connector.getTransceiver().write(new TransmissionObject(this.getNewTransmissionId(), auth), false, ChannelWorker.WriteMode.JSON_PROTOCOL);
                    this.currentStage = Stage.WAITING_FOR_AUTHENTICATION;
                    return this;
                }
                case WAITING_FOR_AUTHENTICATION: 
            }
            TransmissionObject transmissionObject = this.connector.getTransceiver().nextIncomingTransmission();
            byte[] sharedSecret = null;
            Auth auth = (Auth)this.checkResult(transmissionObject, Auth.class);
            byte[] B = auth.getKey();
            BigInteger shared = DHKey.genertateShared(new BigInteger(1, B), this.a, DHKey.BitSize.SIZE_2048);
            String sharedSecretString = shared.toString(16);
            sharedSecret = Tools.getBytes(sharedSecretString);
            String sessionID = auth.getSessionID();
            if (sessionID == null) {
                this.session.setSessionID(null);
                this.session.setSharedSecret(null);
            } else {
                logger.trace("Create new session: " + sessionID);
                this.session.setSessionID(sessionID);
                this.session.setSharedSecret(sharedSecret);
                this.session.setApiVersion(this.settings.getApiVersion());
                this.session.setCompressionType(this.settings.getCompression());
                this.session.setEncryptionType(this.settings.getEncryption());
                this.session.setProtocolType(this.settings.getProtocol());
                this.session.setApiExtensions(this.settings.getApiExtensions());
                this.session.setCapsMetaData(this.getCapsMetaData());
                this.session.setLastUsedTimestamp(System.currentTimeMillis());
                this.session.setTimestamp(System.currentTimeMillis());
                this.connector.objectUpdated(this.session);
                IUserCredential userCredential = this.connector.getUser();
                userCredential.setLastSessionID(sessionID);
                this.connector.objectUpdated(userCredential);
            }
            this.connector.getTransceiver().initialize(sessionID);
            this.currentStage = Stage.DONE;
            return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.WORK, this.connector));
        }
        catch (TransceiverException e) {
            return this.error(e);
        }
    }

    private void logDataPartOne(BigInteger A, BigInteger a) {
        String log = "\r\n";
        log = log + "---- Connection ---- \r\n";
        log = log + "client PubKey:  \r\n";
        log = log + Tools.toHexString(A.toByteArray()) + "\r\n";
        log = log + "\r\n";
        log = log + "client PrivKey: \r\n";
        log = log + Tools.toHexString(a.toByteArray()) + "\r\n";
        log = log + "\r\n";
        SimpleFileWriter.writeTo(StateAuth.class.getName() + "_" + System.currentTimeMillis() + ".txt", log);
    }

    private void logDataPartTwo(byte[] sharedSecret, byte[] B) {
        String log = "\r\n";
        log = log + "sharedSecret:   \r\n";
        log = log + Tools.toHexString(sharedSecret) + "\r\n";
        log = log + "\r\n";
        log = log + "server PubKey:  \r\n";
        log = log + Tools.toHexString(B) + "\r\n";
        log = log + "\r\n";
        log = log + "--------------------------\r\n";
        SimpleFileWriter.writeTo(StateAuth.class.getName() + "_" + System.currentTimeMillis() + ".txt", log);
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.DISCONNECT, this.connector));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.ERROR, this.connector);
        stateSettings.setThrowable(exception);
        return StateFactory.getDefaultFactory().createState(stateSettings);
    }

    private static enum Stage {
        SENDING_AUTHENTICATION,
        WAITING_FOR_AUTHENTICATION,
        DONE;

    }
}

