/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.transceiver.RemoteException;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;

public abstract class ATransceiverState
implements ITransceiverState {
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    public static final int LEVEL_4 = 4;
    public static final int LEVEL_5 = 5;
    protected IConnectionAdapter connector;

    public ATransceiverState(StateConfiguration stateSettings) {
        this.connector = stateSettings.getConnector();
    }

    protected void checkResult(Result result) throws TransceiverException {
        if (result instanceof FailResult) {
            FailResult failResult = (FailResult)result;
            throw new RemoteException(failResult);
        }
    }

    protected void checkResult(Object object) throws TransceiverException {
        if (object instanceof FailResult) {
            FailResult failResult = (FailResult)object;
            throw new RemoteException(failResult);
        }
    }

    protected void checkResult(TransmissionObject transmissionObject) throws TransceiverException {
        IApiObject object = transmissionObject.getObject();
        this.checkResult(object);
    }

    protected <T> T checkResult(Object object, Class<?> clazz) throws TransceiverException {
        if (object instanceof FailResult) {
            FailResult failResult = (FailResult)object;
            throw new RemoteException(failResult);
        }
        if (object instanceof ObjectResult) {
            ObjectResult objectResult = (ObjectResult)object;
            object = objectResult.getObject();
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new TransceiverException(Enumerations.ErrorType.UNEXPECTED_RESULT, "Unexpected result from client");
        }
        return (T)object;
    }

    protected <T> T checkResult(TransmissionObject transmissionObject, Class<?> clazz) throws TransceiverException {
        IApiObject object = transmissionObject.getObject();
        return this.checkResult(object, clazz);
    }

    protected String getNewTransmissionId() {
        return this.connector.getNewTransmissionID();
    }
}

