/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Group;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.io.GetConnectionDetails;
import bsc.sdk.kernel.bus.messages.kernel.io.SendObject;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.bus.messages.kernel.objectmanager.CreateDeviceCache;
import bsc.sdk.kernel.bus.messages.kernel.objectmanager.DeleteDeviceCache;
import bsc.sdk.kernel.bus.messages.kernel.objectmanager.UpdateObject;
import bsc.sdk.kernel.bus.messages.module.objects.AddCommandOffers;
import bsc.sdk.kernel.bus.messages.module.objects.AddMetaInformation;
import bsc.sdk.tools.Tools;
import java.util.HashMap;
import java.util.HashSet;
import net.engio.mbassy.listener.Handler;

public class ObjectManager
extends AApplicationKernel.KernelModule {
    protected final HashMap<String, DeviceCache> deviceCache = new HashMap();
    protected final HashMap<Integer, Group> groups = new HashMap();

    public ObjectManager(AApplicationKernel kernel) {
        super(kernel);
    }

    @Handler
    protected synchronized void createDeviceCache(CreateDeviceCache createDeviceCache) {
        if (!this.deviceCache.containsKey(createDeviceCache.getUserName())) {
            this.deviceCache.put(createDeviceCache.getUserName(), new DeviceCache(createDeviceCache.getUserName()));
        }
    }

    @Handler
    protected synchronized void deleteDeviceCache(DeleteDeviceCache deleteDeviceCache) {
        this.deviceCache.remove(deleteDeviceCache.getUserName());
    }

    @Handler
    protected synchronized void updateObject(UpdateObject objectUpdate) {
        IIdentifiableApiObject object = objectUpdate.getObject();
        for (DeviceCache cache : this.deviceCache.values()) {
            if (object instanceof ADevice) {
                cache.updateDevice((ADevice)object);
                continue;
            }
            if (!(object instanceof ISensor)) continue;
            cache.updateSensor((ISensor)object);
        }
    }

    @Handler
    protected synchronized void monitorTransceiverState(TransceiverState transceiverState) {
        if (transceiverState.getState().equals((Object)TransceiverState.STATE.WORK) || transceiverState.getState().equals((Object)TransceiverState.STATE.TERMINATED)) {
            String source = transceiverState.getSource();
            GetConnectionDetails getDetails = new GetConnectionDetails(source);
            this.postKernelMessage(getDetails).now();
            String user = getDetails.getUser();
            DeviceCache cache = this.deviceCache.get(user);
            if (cache != null) {
                if (transceiverState.getState().equals((Object)TransceiverState.STATE.WORK)) {
                    cache.registerConnection(source);
                } else if (transceiverState.getState().equals((Object)TransceiverState.STATE.TERMINATED)) {
                    cache.unregisterConnection(source);
                }
            }
        }
    }

    protected void sendObject(SendObject sendObject) {
        this.postKernelMessage(sendObject).asynchronously();
    }

    @Override
    public void unload() {
    }

    @Override
    public void init() {
    }

    protected class DeviceCache
    extends HashMap<String, ADevice> {
        private static final long serialVersionUID = 4999101631476225673L;
        protected final String userName;
        protected final HashSet<String> registeredConnections;

        public DeviceCache(String userName) {
            this.userName = userName;
            this.registeredConnections = new HashSet();
        }

        protected synchronized boolean updateDevice(ADevice device) {
            boolean result = false;
            if (device != null) {
                ADevice clonedDevice = Tools.deepClone(device);
                ObjectManager.this.postKernelMessage(new AddCommandOffers(this.getUserName(), clonedDevice)).now();
                ObjectManager.this.postKernelMessage(new AddMetaInformation(this.getUserName(), clonedDevice)).now();
                this.put(clonedDevice.getDeviceID(), clonedDevice);
                this.notifyConnections(clonedDevice);
                result = true;
            }
            return result;
        }

        protected synchronized boolean updateSensor(ISensor sensor) {
            boolean result = false;
            if (sensor != null) {
                String deviceID;
                ADevice device;
                ISensor clonedSensor = Tools.deepClone(sensor);
                ObjectManager.this.postKernelMessage(new AddCommandOffers(this.getUserName(), clonedSensor)).now();
                if (clonedSensor instanceof AMetaInformation) {
                    ObjectManager.this.postKernelMessage(new AddMetaInformation(this.getUserName(), (AMetaInformation)((Object)clonedSensor))).now();
                }
                if ((device = (ADevice)this.get(deviceID = sensor.getDeviceID())) != null) {
                    ISensor s = device.getSensorByID(sensor.getSensorID());
                    device.removeSensor(s);
                    device.addSensor(sensor);
                    this.notifyConnections(sensor);
                    result = true;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyConnections(IIdentifiableApiObject object) {
            HashSet<String> hashSet = this.registeredConnections;
            synchronized (hashSet) {
                for (String con : this.registeredConnections) {
                    ObjectManager.this.sendObject(new SendObject(con, object));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerConnection(String id) {
            HashSet<String> hashSet = this.registeredConnections;
            synchronized (hashSet) {
                this.registeredConnections.add(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregisterConnection(String id) {
            HashSet<String> hashSet = this.registeredConnections;
            synchronized (hashSet) {
                this.registeredConnections.remove(id);
            }
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

