/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.sdk.api.application.environment.ApplicationSettings;
import bsc.sdk.api.application.environment.settings.ClientSettings;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.filter.ObjectTargetFilter;
import bsc.sdk.kernel.bus.messages.kernel.io.SendCommand;
import bsc.sdk.kernel.bus.messages.kernel.io.SendMisc;
import bsc.sdk.kernel.bus.messages.kernel.io.SendObject;
import bsc.sdk.kernel.bus.messages.kernel.io.UpdateTransmission;
import bsc.sdk.kernel.bus.messages.module.ConnectionRequest;
import bsc.sdk.kernel.bus.messages.module.Debug;
import bsc.sdk.kernel.bus.messages.module.DisconnectRequest;
import bsc.sdk.kernel.bus.messages.module.GetConnectionSession;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.io.AConnection;
import bsc.sdk.kernel.modules.io.AConnector;
import bsc.sdk.kernel.modules.io.TransmissionManager;
import bsc.sdk.kernel.modules.user.SessionManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.Handler;

@IKernelModule.ModuleSettings(supportedKernels={BasicApiKernel.class}, dependencies={SessionManager.class, TransmissionManager.class})
public class ClientConnector
extends AConnector {
    protected ClientSettings settings = null;
    protected Map<String, ClientConnection> connections = new ConcurrentHashMap<String, ClientConnection>();

    public ClientConnector(AApplicationKernel kernel) throws UnknownHostException, IOException {
        super(kernel);
    }

    @Handler
    protected void connect(ConnectionRequest connectionRequest) {
        connectionRequest.setCreatedTarget(this.connect(connectionRequest.getConnectionProfile()));
    }

    public String connect(ConnectionProfile connectionProfile) {
        ClientConnection connection = new ClientConnection(connectionProfile, this);
        String id = connection.getId();
        this.connections.put(id, connection);
        ObjectTargetFilter.registerDynamicFilterValue(this.getUniqueID(), id);
        return id;
    }

    @Handler(filters={@Filter(value=ClientCommandFilter.class)})
    protected void disconnect(DisconnectRequest disconnectRequest) {
        ClientConnection connection = this.connections.get(disconnectRequest.getTarget());
        if (connection != null) {
            connection.disconnect(false);
            this.connections.remove(connection.getId());
        }
        ObjectTargetFilter.unregisterDynamicFilterValue(this.getUniqueID(), disconnectRequest.getTarget());
    }

    @Handler(filters={@Filter(value=ClientCommandFilter.class)})
    protected void getConnectionSession(GetConnectionSession getConnectionSession) {
        getConnectionSession.setSession(this.getConnectionSession(getConnectionSession.getTarget()));
    }

    public ISession getConnectionSession(String connectionID) {
        ISession result = null;
        ClientConnection connection = this.connections.get(connectionID);
        if (connection != null) {
            result = connection.getSession();
        }
        return result;
    }

    @Handler(filters={@Filter(value=ClientCommandFilter.class)})
    protected void sendCommand(SendCommand sendCommand) {
        sendCommand.setTransmission(this.send(sendCommand.getTarget(), (IApiObject)sendCommand.getObject()));
    }

    @Handler(filters={@Filter(value=ClientCommandFilter.class)})
    protected void sendObject(SendObject message) {
        message.setTransmission(this.send(message.getTarget(), (IApiObject)message.getObject()));
    }

    @Handler(filters={@Filter(value=ClientCommandFilter.class)})
    protected void sendMisc(SendMisc message) {
        message.setTransmission(this.send(message.getTarget(), (IApiObject)message.getObject()));
    }

    protected ITransmission send(String target, IApiObject object) {
        ClientConnection connection = this.connections.get(target);
        if (connection != null) {
            long timeout = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(2L);
            while (!connection.isConnectionReadyForOperation() && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ITransmission transmission = connection.sendObject(object);
            this.postKernelMessage(new UpdateTransmission(transmission)).now();
            return transmission;
        }
        return null;
    }

    @Override
    public ApplicationSettings getApplicationSettings() {
        if (this.settings == null) {
            ArrayList<Enumerations.ProtocolType> protocols = new ArrayList<Enumerations.ProtocolType>();
            protocols.add(Enumerations.ProtocolType.JSON);
            ArrayList<Enumerations.EncryptionType> encryptions = new ArrayList<Enumerations.EncryptionType>();
            encryptions.add(Enumerations.EncryptionType.AES);
            ArrayList<Enumerations.CompressionType> compressions = new ArrayList<Enumerations.CompressionType>();
            compressions.add(Enumerations.CompressionType.DEFLATE);
            ArrayList<Enumerations.ApiVersion> apiVersions = new ArrayList<Enumerations.ApiVersion>();
            apiVersions.add(this.getApiVersion());
            this.settings = new ClientSettings(protocols, encryptions, compressions, apiVersions);
        }
        return this.settings;
    }

    @Override
    public void unload() {
        Iterator<ClientConnection> itr = this.connections.values().iterator();
        while (itr.hasNext()) {
            ClientConnection connection = itr.next();
            connection.disconnect(false);
            itr.remove();
        }
        ObjectTargetFilter.unregisterDynamicFilterKey(this.getUniqueID());
    }

    @Override
    public void init() {
    }

    public static class ClientCommandFilter
    extends ObjectTargetFilter {
        public ClientCommandFilter() {
            super(ClientConnector.getUniqueID(ClientConnector.class));
        }
    }

    public static class ConnectionProfile
    implements Serializable {
        private static final long serialVersionUID = 7883265388845755554L;
        private final String user;
        private final String password;
        private String server;
        private int port;
        private String sessionID;
        private final String vid;

        public ConnectionProfile(String user, String password, String server, int port) {
            this(user, password, server, port, null, null);
        }

        public ConnectionProfile(String user, String password, String server, int port, String sessionID, String vid) {
            this.user = user;
            this.password = password;
            this.server = server;
            this.port = port;
            this.sessionID = sessionID;
            this.vid = vid;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return this.user + "@" + this.server + ":" + this.port;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public void setSessionID(String sessionID) {
            this.sessionID = sessionID;
        }

        public String getVid() {
            return this.vid;
        }
    }

    protected class ClientConnection
    extends AConnection {
        public ClientConnection(ConnectionProfile connectionProfile, ClientConnector connector) {
            super(connectionProfile, connector);
        }

        @Override
        public void debug(Object obj) {
            String username = this.getUser().getUserName();
            String vid = this.getConnectionProfile().getVid();
            String usernameAtVid = username + "@" + vid;
            ClientConnector.this.postKernelMessage(new Debug(this.getId(), obj, usernameAtVid)).now();
        }

        @Override
        public void fireMessage(Object message) {
            ClientConnector.this.postKernelMessage(message).now();
        }
    }
}

