/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.impl;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.commands.GetAllObjectsCommand;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.extension.modules.teachin.notification.AddMetaDataHandler;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.DeviceValidator;
import bsc.sdk.kernel.bus.messages.kernel.io.ReceivedResult;
import bsc.sdk.kernel.bus.messages.kernel.io.SendCommand;
import bsc.sdk.kernel.bus.messages.module.ConnectionRequest;
import bsc.sdk.kernel.bus.messages.module.DisconnectRequest;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.io.ClientConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceValidatorClient
extends BasicApiKernel {
    protected static Logger logger = LoggerFactory.getLogger(DeviceValidatorClient.class);
    protected boolean printList = false;
    protected boolean validate = true;
    protected boolean finished = false;
    protected DeviceValidator deviceValidator = new DeviceValidator(logger);
    private String connectionID = null;

    public DeviceValidatorClient(String user, String password, String server, int port) {
        this(user, password, server, port, false, true);
    }

    public DeviceValidatorClient(String user, String password, String server, int port, boolean printList, boolean validate) {
        this.printList = printList;
        this.validate = validate;
        logger.info("Connecting to " + server + ":" + port + "...");
        this.connect(user, password, server, port);
        logger.info("Request objects...");
        this.sendCommand(new GetAllObjectsCommand());
        logger.info("Waiting for result...");
        while (!this.finished) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Disconnecting...");
        this.disconnect();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("Shutdown client...");
        this.shutdown();
    }

    public String connect(String user, String password, String server, int port) {
        ClientConnector.ConnectionProfile profile = new ClientConnector.ConnectionProfile(user, DigestUtils.sha256Hex((String)password).toUpperCase(), server, port, null, null);
        ConnectionRequest connectionRequest = new ConnectionRequest(profile);
        this.postKernelMessage(connectionRequest).now();
        this.connectionID = connectionRequest.getCreatedTarget();
        return connectionRequest.getCreatedTarget();
    }

    public void disconnect() {
        DisconnectRequest disconnectRequest = new DisconnectRequest(this.connectionID);
        this.connectionID = null;
        this.postKernelMessage(disconnectRequest).now();
    }

    public void sendCommand(Command command) {
        if (command != null) {
            SendCommand c = new SendCommand(this.connectionID, command);
            this.postKernelMessage(c).now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    private void handleCommandResult(ReceivedResult receivedResult) {
        DeviceValidatorClient deviceValidatorClient = this;
        synchronized (deviceValidatorClient) {
            Result result = (Result)receivedResult.getObject();
            if (result instanceof ObjectResult) {
                logger.info("Processing object result...");
                ObjectResult or = (ObjectResult)result;
                IApiObject obj = or.getObject();
                if (obj instanceof ObjectContainer) {
                    String referenceID;
                    ADevice device2;
                    ObjectContainer container = (ObjectContainer)obj;
                    List objects = container.getObjects();
                    Iterator itr = objects.iterator();
                    logger.info("#######################");
                    logger.info("Collecting devices...");
                    logger.info("#######################");
                    while (itr.hasNext()) {
                        IIdentifiableApiObject apiObj = (IIdentifiableApiObject)itr.next();
                        if (apiObj instanceof ADevice) {
                            device2 = (ADevice)apiObj;
                            referenceID = device2.getMetaInformation(Enumerations.EXTENSION_ID.TEACHIN.name(), AddMetaDataHandler.DETAILS.REFERENCE_ID.name());
                            IReferenceID refIDObj = ReferenceIDs.getReferenceIDbyString(referenceID);
                            if (referenceID == null) {
                                logger.info("Drop device with no referenceID: " + device2.getDeviceID() + " (" + device2.getName() + ") | " + device2.getClass().getName());
                                itr.remove();
                                continue;
                            }
                            if (refIDObj != null) continue;
                            logger.info("Drop device with unknown ReferenceID (" + referenceID + ") " + device2.getDeviceID() + " (" + device2.getName() + ") | " + device2.getClass().getName());
                            itr.remove();
                            continue;
                        }
                        logger.info("Drop non device object: " + apiObj.getClass().getName());
                        itr.remove();
                    }
                    if (this.printList) {
                        logger.info("#######################");
                        logger.info("Device list:");
                        logger.info("#######################");
                        ArrayList<PrintableEntry> printableEntries = new ArrayList<PrintableEntry>();
                        for (ADevice device2 : objects) {
                            referenceID = device2.getMetaInformation(Enumerations.EXTENSION_ID.TEACHIN.name(), AddMetaDataHandler.DETAILS.REFERENCE_ID.name());
                            List<ISensor> sensors = device2.getSensors();
                            String[] sensorArray = new String[sensors.size()];
                            Iterator<ISensor> sensorItr = sensors.iterator();
                            int i = 0;
                            while (sensorItr.hasNext()) {
                                ISensor sensor = sensorItr.next();
                                sensorArray[i] = "-->" + sensor.getName() + " | " + sensor.getClass().getSimpleName() + " " + sensor.getSensorID();
                                ++i;
                            }
                            printableEntries.add(new PrintableEntry(device2.getDeviceID(), referenceID, sensorArray));
                        }
                        Collections.sort(printableEntries);
                        for (PrintableEntry printableEntry : printableEntries) {
                            logger.info(printableEntry.deviceID);
                            logger.info(printableEntry.referenceID);
                            for (String sentry : printableEntry.sensors) {
                                logger.info(sentry);
                            }
                            logger.info("");
                        }
                    }
                    if (this.validate) {
                        logger.info("#######################");
                        logger.info("Validate device list...");
                        logger.info("#######################");
                        itr = objects.iterator();
                        int toValidateCount = objects.size();
                        while (itr.hasNext()) {
                            device2 = (ADevice)itr.next();
                            if (this.deviceValidator.validateDevice(device2)) continue;
                            itr.remove();
                        }
                        int validDevices = objects.size();
                        logger.info("#######################");
                        logger.info("Result:");
                        logger.info("#######################");
                        logger.info("valid=" + validDevices);
                        logger.info("invalid=" + (toValidateCount - validDevices));
                    }
                    this.finished = true;
                }
            }
        }
    }

    public static class PrintableEntry
    implements Comparable<PrintableEntry> {
        protected String deviceID = null;
        protected String referenceID = null;
        protected ArrayList<String> sensors = new ArrayList();

        public PrintableEntry(String deviceID, String referenceID, String ... sensors) {
            this.deviceID = deviceID;
            this.referenceID = referenceID;
            if (sensors != null) {
                for (String s : sensors) {
                    this.sensors.add(s);
                }
            }
        }

        @Override
        public int compareTo(PrintableEntry o) {
            if (this.referenceID != null && o.referenceID != null) {
                return this.referenceID.compareTo(o.referenceID);
            }
            return -1;
        }
    }
}

