/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.bus.filter;

import bsc.sdk.kernel.bus.messages.ATargetedMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.subscription.SubscriptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectTargetFilter
implements IMessageFilter<ATargetedMessage> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTargetFilter.class);
    private static final Map<String, Set<String>> dynamicFilterStorage = new HashMap<String, Set<String>>();
    private final String uniqueID;

    public ObjectTargetFilter(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public boolean accepts(ATargetedMessage message, SubscriptionContext context) {
        Set<String> filterStrings = dynamicFilterStorage.get(this.uniqueID);
        return filterStrings == null ? false : filterStrings.contains(message.getTarget());
    }

    public static boolean registerDynamicFilterValue(String uniqueID, String filterString) {
        if (uniqueID == null || filterString == null) {
            return false;
        }
        Set<String> filterStrings = dynamicFilterStorage.get(uniqueID);
        if (filterStrings == null) {
            logger.trace(uniqueID + " | register filter");
            filterStrings = new HashSet<String>();
            dynamicFilterStorage.put(uniqueID, filterStrings);
        }
        logger.trace(uniqueID + " | register value: " + filterString);
        return filterStrings.add(filterString);
    }

    public static boolean unregisterDynamicFilterValue(String uniqueID, String filterString) {
        logger.trace(uniqueID + " | unregister value: " + filterString);
        if (uniqueID == null || filterString == null) {
            return false;
        }
        Set<String> filterStrings = dynamicFilterStorage.get(uniqueID);
        if (filterStrings == null) {
            return false;
        }
        boolean result = filterStrings.remove(filterString);
        if (filterString.isEmpty()) {
            logger.trace(uniqueID + " | is empty");
            ObjectTargetFilter.unregisterDynamicFilterKey(uniqueID);
        }
        return result;
    }

    public static boolean unregisterDynamicFilterKey(String uniqueID) {
        logger.trace(uniqueID + " | unregister filter");
        Set<String> filterStrings = dynamicFilterStorage.get(uniqueID);
        if (filterStrings == null) {
            return false;
        }
        filterStrings.clear();
        return dynamicFilterStorage.remove(uniqueID) != null;
    }

    public static @interface FilterSettings {
        public Class<?>[] supportedClasses() default {};

        public boolean acceptSubclasses() default true;
    }
}

