/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.bus.filter;

import bsc.sdk.kernel.bus.messages.IObjectContainer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.subscription.SubscriptionContext;

public class ObjectContainerFilter
implements IMessageFilter<IObjectContainer> {
    protected final Set<Class<?>> supportedClasses = ObjectContainerFilter.getSupportedClassesFromAnnotation(this.getClass(), this.acceptSubclasses);
    protected boolean acceptSubclasses = true;

    public boolean accepts(IObjectContainer message, SubscriptionContext context) {
        return this.checkClass(message.getObject().getClass());
    }

    protected boolean checkClass(Class<?> clazz) {
        boolean matchFound;
        block1: {
            Class<?> c;
            matchFound = this.supportedClasses.contains(clazz);
            if (matchFound || !this.acceptSubclasses) break block1;
            Iterator<Class<?>> i$ = this.supportedClasses.iterator();
            while (i$.hasNext() && !(matchFound = (c = i$.next()).isAssignableFrom(clazz))) {
            }
        }
        return matchFound;
    }

    public static Set<Class<?>> getSupportedClassesFromAnnotation(Class<?> clazz, boolean acceptSubclasses) {
        HashSet result = new HashSet();
        ObjectContainerFilterSettings settings = clazz.getAnnotation(ObjectContainerFilterSettings.class);
        if (settings != null) {
            acceptSubclasses = settings.acceptSubclasses();
            for (Class<?> c : settings.supportedClasses()) {
                result.add(c);
            }
        }
        return result;
    }

    public static @interface ObjectContainerFilterSettings {
        public Class<?>[] supportedClasses() default {};

        public boolean acceptSubclasses() default true;
    }
}

