/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel;

import bsc.sdk.kernel.IKernelSettings;
import bsc.sdk.kernel.modules.IKernelModule;
import java.util.Collection;
import java.util.HashSet;

public class KernelParameters {
    protected final IKernelSettings kernelSettingsImpl;
    protected final Collection<Class<? extends IKernelModule>> dynamicModules = new HashSet<Class<? extends IKernelModule>>();
    protected final Collection<Class<? extends IKernelModule>> staticModules = new HashSet<Class<? extends IKernelModule>>();
    protected final Collection<Class<? extends IKernelModule>> blacklistedModules = new HashSet<Class<? extends IKernelModule>>();

    private KernelParameters() {
        this.kernelSettingsImpl = null;
    }

    public KernelParameters(IKernelSettings kernelSettingsImpl, Class<?> ... dynamicModules) {
        if (dynamicModules != null) {
            HashSet modulesToLoad = new HashSet();
            for (Class<?> iKernelModule : dynamicModules) {
                if (!IKernelModule.class.isAssignableFrom(iKernelModule)) continue;
                modulesToLoad.add(iKernelModule);
            }
            this.dynamicModules.addAll(modulesToLoad);
        }
        this.kernelSettingsImpl = kernelSettingsImpl;
    }

    public KernelParameters(IKernelSettings kernelSettingsImpl, Collection<Class<? extends IKernelModule>> dynamicModules, Collection<Class<? extends IKernelModule>> staticModules) {
        this(kernelSettingsImpl, dynamicModules, staticModules, null);
    }

    public KernelParameters(IKernelSettings kernelSettingsImpl, Collection<Class<? extends IKernelModule>> dynamicModules, Collection<Class<? extends IKernelModule>> staticModules, Collection<Class<? extends IKernelModule>> blacklistedModules) {
        this.kernelSettingsImpl = kernelSettingsImpl;
        if (dynamicModules != null) {
            this.dynamicModules.addAll(dynamicModules);
        }
        if (staticModules != null) {
            this.staticModules.addAll(staticModules);
        }
        if (blacklistedModules != null) {
            this.blacklistedModules.addAll(blacklistedModules);
        }
    }

    public IKernelSettings getKernelSettingsImpl() {
        return this.kernelSettingsImpl;
    }

    public Collection<Class<? extends IKernelModule>> getDynamicModules() {
        return this.dynamicModules;
    }

    public Collection<Class<? extends IKernelModule>> getStaticModules() {
        return this.staticModules;
    }

    public Collection<Class<? extends IKernelModule>> getBlacklistedModules() {
        return this.blacklistedModules;
    }

    public static class NoKernelParameters
    extends KernelParameters {
    }
}

