/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.session.manager;

import bsc.sdk.api.AManager;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.executors.INamedRunnable;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.idpool.IdPoolSettings;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ASessionFactory;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.ISessionManager;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class ASessionManager
extends AManager<SessionIdentifier, ISession>
implements ISessionManager {
    protected long sessionTimeout = 168L;
    protected TimeUnit sessionTimeoutTimeUnit = TimeUnit.HOURS;
    protected int maxSessions = 50000;
    protected long cleanupInterval = 1L;
    protected TimeUnit cleanupIntervalTimeUnit = TimeUnit.HOURS;
    protected Runnable autoCleanupExecutor = new Executor();
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask = null;

    @Override
    public Collection<SessionIdentifier> getSessionsForUser(UserCredentialIdentifier user) {
        HashSet<SessionIdentifier> result = new HashSet<SessionIdentifier>();
        if (user != null) {
            for (ISession session : this.objects.values()) {
                if (!session.getUserCredentialID().equals(user.getUserCredentialID())) continue;
                result.add((SessionIdentifier)this.getIdentifierInstance(session));
            }
        }
        return result;
    }

    @Override
    public void cleanupSessions() {
        this.logger.trace("Cleanup sessions");
        HashMap sessions = new HashMap(this.objects);
        HashSet<String> userIdentifierString = new HashSet<String>();
        for (UserCredentialIdentifier userCredentialIdentifier : this.getEnvironment().getUserCredentialManager().getUserCredentialList()) {
            userIdentifierString.add(userCredentialIdentifier.getUserCredentialID());
        }
        for (ISession s : sessions.values()) {
            long timeout = s.getTimestamp() + this.sessionTimeoutTimeUnit.toMillis(this.sessionTimeout);
            if (timeout < System.currentTimeMillis()) {
                this.logger.trace("Session " + s.getSessionID() + " expired!");
                this.removeObject((SessionIdentifier)this.getIdentifierInstance(s));
                continue;
            }
            if (userIdentifierString.contains(s.getUserCredentialID())) continue;
            this.logger.trace("Session " + s.getSessionID() + " invalid. User doesn't exist anymore");
            this.removeObject((SessionIdentifier)this.getIdentifierInstance(s));
        }
        ArrayList sessionsMax = new ArrayList(this.objects.values());
        int difference = sessionsMax.size() - this.maxSessions;
        if (difference > 0) {
            this.logger.trace("Remove " + difference + " sessions because maxSessions is reached!");
            Collections.sort(sessionsMax);
            for (int i = 0; i < difference; ++i) {
                ISession session = (ISession)sessionsMax.get(i);
                this.removeObject((SessionIdentifier)this.getIdentifierInstance(session));
            }
        }
        this.save();
    }

    @Override
    protected ISession getNewObjectInstance(ISession orgObject) {
        return ASessionFactory.createNewInstance(Objects.requireNonNull(orgObject, "orgObject must not be null!"));
    }

    @Override
    protected void _init() {
        this.load();
        this.startCleanupTimer();
    }

    @Override
    protected IdPoolSettings getIdPoolSettings() {
        return new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM_GUID, this.sessionTimeoutTimeUnit.toMillis(this.sessionTimeout), "", "", 25, "", 0);
    }

    @Override
    public String getUniqueSessionID() {
        return this.getUniqueID();
    }

    @Override
    protected void _shutdown() {
        this.stopCleanupTimer();
        this.save();
    }

    protected boolean startCleanupTimer() {
        if (this.scheduledTask == null) {
            this.scheduledTask = this.getEnvironment().getApplication().getExecutorServiceBackgroundTasks().scheduleAtFixedDelay(this.getAutoCleanupExecutor(), this.getCleanupInterval(), this.getCleanupInterval(), this.getCleanupIntervalTimeUnit());
        }
        return this.scheduledTask != null;
    }

    protected boolean stopCleanupTimer() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
        return this.scheduledTask == null;
    }

    protected boolean restartCleanupTimer() {
        boolean result;
        boolean bl = result = this.scheduledTask != null;
        if (result) {
            result &= this.stopCleanupTimer();
            result &= this.startCleanupTimer();
        }
        return result;
    }

    protected boolean isCleanupTimerStarted() {
        return this.scheduledTask != null;
    }

    protected Runnable getAutoCleanupExecutor() {
        return this.autoCleanupExecutor;
    }

    protected boolean setAutoCleanupExecutor(Runnable autoCleanupExecutor) {
        boolean somethingChanged;
        boolean bl = somethingChanged = this.autoCleanupExecutor == null && autoCleanupExecutor != null || !this.autoCleanupExecutor.equals(autoCleanupExecutor);
        if (somethingChanged) {
            this.autoCleanupExecutor = autoCleanupExecutor;
            return this.restartCleanupTimer();
        }
        return false;
    }

    protected long getCleanupInterval() {
        return this.cleanupInterval;
    }

    protected boolean setCleanupInterval(long cleanupInterval) {
        boolean somethingChanged;
        boolean bl = somethingChanged = this.cleanupInterval != cleanupInterval;
        if (somethingChanged) {
            this.cleanupInterval = cleanupInterval;
            return this.restartCleanupTimer();
        }
        return false;
    }

    protected TimeUnit getCleanupIntervalTimeUnit() {
        return this.cleanupIntervalTimeUnit;
    }

    @Override
    public boolean removeObject(SessionIdentifier objectIdentifier) {
        this.freeID(objectIdentifier.getSessionID());
        return super.removeObject(objectIdentifier);
    }

    protected boolean setCleanupIntervalTimeUnit(TimeUnit cleanupIntervalTimeUnit) {
        boolean somethingChanged;
        boolean bl = somethingChanged = !this.cleanupIntervalTimeUnit.equals((Object)cleanupIntervalTimeUnit);
        if (somethingChanged) {
            this.cleanupIntervalTimeUnit = cleanupIntervalTimeUnit;
            return this.restartCleanupTimer();
        }
        return false;
    }

    protected long getSessionTimeout() {
        return this.sessionTimeout;
    }

    protected void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    protected TimeUnit getSessionTimeoutTimeUnit() {
        return this.sessionTimeoutTimeUnit;
    }

    protected void setSessionTimeoutTimeUnit(TimeUnit sessionTimeoutTimeUnit) {
        this.sessionTimeoutTimeUnit = sessionTimeoutTimeUnit;
    }

    protected int getMaxSessions() {
        return this.maxSessions;
    }

    protected void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    @Override
    public SessionIdentifier getSessionByID(String sessionID) {
        if (sessionID != null) {
            for (SessionIdentifier value : this.identifierCache.values()) {
                if (!sessionID.equals(value.getSessionID()) || !value.objectExists()) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }

    protected class Executor
    implements INamedRunnable {
        protected Executor() {
        }

        @Override
        public void run() {
            ASessionManager.this.cleanupSessions();
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName() + "->Worker";
        }
    }
}

