/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.group;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.IUserGroup;
import bsc.sdk.api.user.group.Permission;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UserGroupIdentifier
extends AIdentifier<IUserGroup> {
    public static int USER_GROUP_ID_PART = 0;
    private final String userGroupID = this.getPathPart(USER_GROUP_ID_PART);

    public UserGroupIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getUserGroupID() {
        return this.userGroupID;
    }

    public static URI generateURI(String userGroupID, String applicationID, String host) {
        if (userGroupID != null && applicationID != null && host != null) {
            try {
                String uriString = IUserGroup.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(userGroupID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String userGroupID, Environment enviromentSettings) {
        return UserGroupIdentifier.generateURI(userGroupID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static UserGroupIdentifier createIdentifierInstance(String userGroupID, Environment enviromentSettings) throws URISyntaxException {
        return new UserGroupIdentifier(UserGroupIdentifier.generateURI(userGroupID, enviromentSettings));
    }

    public static UserGroupIdentifier createIdentifierInstance(IUserGroup userGroup, Environment enviromentSettings) throws URISyntaxException {
        return new UserGroupIdentifier(UserGroupIdentifier.generateURI(Objects.requireNonNull(userGroup, "userGroup must not be null!").getID(), enviromentSettings));
    }

    public void joinGroup(UserCredentialIdentifier user) {
        user.joinGroup(this);
    }

    public void leaveGroup(UserCredentialIdentifier user) {
        user.leaveGroup(this);
    }

    public Set<UserCredentialIdentifier> getMembers() {
        return this.getEnvironment().getUserCredentialManager().getGroupMembers(this);
    }

    @Override
    public IUserGroup getObjectInstance() {
        return (IUserGroup)this.environment.getUserGroupManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getUserGroupManager().removeObject(this);
    }

    @Override
    public boolean updateObject(IUserGroup objectInstance) {
        return this.environment.getUserGroupManager().updateObject(objectInstance);
    }

    @Override
    public boolean saveObject() {
        return this.environment.getUserGroupManager().save(this);
    }

    public Map<String, EnumSet<Permission>> getPermissions() {
        Map<String, EnumSet<Permission>> result = null;
        if (this.objectExists()) {
            result = this.getObjectInstance().getPermissions();
        }
        return result;
    }
}

