/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.group;

import bsc.api.IUpdateableObject;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.user.group.IUserGroup;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.api.user.group.UserGroupIdentifier;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class UserGroup
implements IUserGroup {
    private static final long serialVersionUID = 5974785723450007934L;
    private String name;
    private String id;
    protected boolean systemGroup = false;
    protected Map<String, EnumSet<Permission>> permissions = new ConcurrentHashMap<String, EnumSet<Permission>>();

    public UserGroup(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null!");
        this.id = name;
    }

    public UserGroup(String id, String name) {
        this.id = Objects.requireNonNull(id, "id must not be null!");
        this.name = Objects.requireNonNull(name, "name must not be null!");
    }

    public UserGroup(IUserGroup userGroup) {
        this.updateObject(userGroup);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null!");
    }

    @Override
    public void addPermissions(ObjectIdentifier identifier, EnumSet<Permission> permissions) {
        this.addPermissions(identifier.getFullQualifiedIdentifiableString(), permissions);
    }

    @Override
    public void addPermissions(String identifierString, EnumSet<Permission> permissions) {
        if (identifierString == null || permissions == null) {
            return;
        }
        EnumSet<Permission> p = this.permissions.get(identifierString);
        if (p == null) {
            p = EnumSet.copyOf(permissions);
            this.permissions.put(identifierString, p);
        } else {
            p.addAll(permissions);
        }
    }

    @Override
    public void addPermission(ObjectIdentifier identifier, Permission permission) {
        this.addPermission(identifier.getFullQualifiedIdentifiableString(), permission);
    }

    @Override
    public void addPermission(String identifierString, Permission permission) {
        if (this.permissions != null) {
            this.addPermissions(identifierString, EnumSet.of(permission));
        }
    }

    @Override
    public void removeObjectPermission(String identifierString) {
        this.permissions.remove(identifierString);
    }

    @Override
    public void removePermission(String identifierString, Permission permission) {
        EnumSet<Permission> p = this.permissions.get(identifierString);
        if (p != null) {
            p.remove((Object)permission);
        }
    }

    @Override
    public void removePermissions(String identifierString, EnumSet<Permission> permissions) {
        EnumSet<Permission> p = this.permissions.get(identifierString);
        if (p != null) {
            p.removeAll(permissions);
        }
    }

    @Override
    public void removeObjectPermission(ObjectIdentifier identifier) {
        this.removeObjectPermission(identifier.getFullQualifiedIdentifiableString());
    }

    @Override
    public void removePermission(ObjectIdentifier identifier, Permission permission) {
        this.removePermission(identifier.getFullQualifiedIdentifiableString(), permission);
    }

    @Override
    public void removePermissions(ObjectIdentifier identifier, EnumSet<Permission> permissions) {
        this.removePermissions(identifier.getFullQualifiedIdentifiableString(), permissions);
    }

    @Override
    public EnumSet<Permission> getPermissions(String identifierString) {
        EnumSet<Permission> result = null;
        if (this.permissions.containsKey(identifierString)) {
            result = EnumSet.copyOf(this.permissions.get(identifierString));
        }
        return result;
    }

    @Override
    public EnumSet<Permission> getPermissions(ObjectIdentifier identifier) {
        return this.getPermissions(identifier.getFullQualifiedIdentifiableString());
    }

    @Override
    public Map<String, EnumSet<Permission>> getPermissions() {
        return new HashMap<String, EnumSet<Permission>>(this.permissions);
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return UserGroupIdentifier.generateURI(this.name, applicationID, host);
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof IUserGroup && !objectInstance.equals(this)) {
            IUserGroup ug = (IUserGroup)objectInstance;
            this.name = ug.getName();
            this.id = ug.getID();
            this.permissions.clear();
            this.permissions.putAll(ug.getPermissions());
            return true;
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        IUserGroup ug;
        boolean equals = objectInstance instanceof IUserGroup;
        if (equals && (equals &= (ug = (IUserGroup)objectInstance).getName() != null)) {
            equals &= ug.getID().equals(this.getID());
            equals &= ug.getName().equals(this.getName());
            Map<String, EnumSet<Permission>> perm = this.getPermissions();
            if (equals &= perm.size() == ug.getPermissions().size()) {
                for (Map.Entry<String, EnumSet<Permission>> entry : ug.getPermissions().entrySet()) {
                    EnumSet<Permission> v = perm.get(entry.getKey());
                    if ((equals &= v != null) && (equals &= v.size() == entry.getValue().size())) {
                        Permission permission;
                        Iterator i$ = entry.getValue().iterator();
                        while (i$.hasNext() && (equals &= v.contains((Object)(permission = (Permission)((Object)i$.next()))))) {
                        }
                    }
                    if (equals) continue;
                    break;
                }
            }
        }
        return equals;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean isSystemGroup() {
        return this.systemGroup;
    }

    public void setSystemGroup(boolean systemGroup) {
        this.systemGroup = systemGroup;
    }
}

