/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.credential.manager;

import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Group;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.api.user.group.UserGroupIdentifier;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UserCredentialIdentifier
extends AIdentifier<IUserCredential> {
    public static int USER_CREDENTIAL_ID_PART = 0;
    private final String userCredentialID = this.getPathPart(USER_CREDENTIAL_ID_PART);

    public UserCredentialIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getUserCredentialID() {
        return this.userCredentialID;
    }

    public static URI generateURI(String userCredentialID, String applicationID, String host) {
        if (userCredentialID != null && applicationID != null && host != null) {
            try {
                String uriString = IUserCredential.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(userCredentialID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String userCredentialID, Environment enviromentSettings) {
        return UserCredentialIdentifier.generateURI(userCredentialID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static UserCredentialIdentifier createIdentifierInstance(String userCredentialID, Environment enviromentSettings) throws URISyntaxException {
        return new UserCredentialIdentifier(UserCredentialIdentifier.generateURI(userCredentialID, enviromentSettings));
    }

    public static UserCredentialIdentifier createIdentifierInstance(IUserCredential userCredential, Environment enviromentSettings) throws URISyntaxException {
        return new UserCredentialIdentifier(UserCredentialIdentifier.generateURI(Objects.requireNonNull(userCredential, "userCredential must not be null!").getUserName(), enviromentSettings));
    }

    public EnumSet<Permission> getEffektivePermissions(ObjectIdentifier objectIdentifier) {
        return this.getEnvironment().getObjectManager().getUserPermissions(this, objectIdentifier);
    }

    public void joinGroup(UserGroupIdentifier group) {
        this.joinGroup(group, true);
    }

    public void joinGroup(UserGroupIdentifier group, boolean waitForCompletion) {
        IUserCredential user = this.getObjectInstance();
        if (user != null) {
            user.joinGroup(group.getUserGroupID());
            this.updateObject(user);
            if (waitForCompletion) {
                this.getEnvironment().getObjectManager().waitForUserObjectCacheRebuild(this);
            }
        }
    }

    public void leaveGroup(UserGroupIdentifier group) {
        this.leaveGroup(group, true);
    }

    public void leaveGroup(UserGroupIdentifier group, boolean waitForCompletion) {
        IUserCredential user = this.getObjectInstance();
        if (user != null) {
            user.leaveGroup(group.getUserGroupID());
            this.updateObject(user);
            if (waitForCompletion) {
                this.getEnvironment().getObjectManager().waitForUserObjectCacheRebuild(this);
            }
        }
    }

    public void leaveAllGroups() {
        for (UserGroupIdentifier group : this.getUserGroupIdentifiers()) {
            this.leaveGroup(group, false);
        }
    }

    public Collection<SessionIdentifier> getSessions() {
        return this.getEnvironment().getSessionManager().getSessionsForUser(this);
    }

    public void sendCommand(Command command) {
        this.getEnvironment().getTransceiverManager().sendCommandToClient(command, this);
    }

    public void sendObject(IApiObject object) {
        this.getEnvironment().getTransceiverManager().sendObjectToClient(object, this);
    }

    public void disconnect() {
        this.getEnvironment().getTransceiverManager().disconnect(this);
    }

    public int getOpenConnectionsCount() {
        return this.getEnvironment().getTransceiverManager().getOpenConnectionSlotCount(this);
    }

    public Set<UserGroupIdentifier> getUserGroupIdentifiers() {
        return this.getEnvironment().getUserCredentialManager().getUserGroups(this);
    }

    public Set<IIdentifiableApiObject> getAccessibleObjects() {
        return this.getEnvironment().getObjectManager().getAllObjectsForUser(this);
    }

    public Set<ADevice> getAccessibleDevices() {
        HashSet<ADevice> result = new HashSet<ADevice>();
        for (IIdentifiableApiObject iIdentifiableApiObject : this.getEnvironment().getObjectManager().getObjectsForUser(this, EnumSet.of(ObjectIdentifier.OBJECT_TYPE.DEVICE))) {
            try {
                result.add((ADevice)iIdentifiableApiObject);
            }
            catch (ClassCastException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Set<Group> getAccessibleGroups() {
        HashSet<Group> result = new HashSet<Group>();
        for (IIdentifiableApiObject iIdentifiableApiObject : this.getEnvironment().getObjectManager().getObjectsForUser(this, EnumSet.of(ObjectIdentifier.OBJECT_TYPE.GROUP))) {
            try {
                result.add((Group)iIdentifiableApiObject);
            }
            catch (ClassCastException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Set<ISensor> getAccessibleSensors() {
        HashSet<ISensor> result = new HashSet<ISensor>();
        for (IIdentifiableApiObject iIdentifiableApiObject : this.getEnvironment().getObjectManager().getObjectsForUser(this, EnumSet.of(ObjectIdentifier.OBJECT_TYPE.SENSOR))) {
            try {
                result.add((ISensor)iIdentifiableApiObject);
            }
            catch (ClassCastException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public void deleteAllSessions() {
        this.disconnect();
        for (SessionIdentifier sessionIdentifier : this.getSessions()) {
            sessionIdentifier.deleteObject();
        }
    }

    @Override
    public IUserCredential getObjectInstance() {
        return (IUserCredential)this.environment.getUserCredentialManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        this.deleteAllSessions();
        return this.environment.getUserCredentialManager().removeObject(this);
    }

    @Override
    public boolean updateObject(IUserCredential objectInstance) {
        return this.environment.getUserCredentialManager().updateObject(objectInstance);
    }

    @Override
    public boolean saveObject() {
        return this.environment.getUserCredentialManager().save(this);
    }

    public void rebuildObjectCache() {
        this.environment.getObjectManager().rebuildUserObjectCache(this);
    }

    public void rebuildObjectCache(ObjectIdentifier object) {
        this.environment.getObjectManager().rebuildUserObjectCache(this, object);
    }
}

