/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.credential.impl;

import bsc.api.IUpdateableObject;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class UserCredential
implements IUserCredential {
    private static final long serialVersionUID = 7629274904100731266L;
    protected boolean active;
    protected String user;
    protected String password;
    protected String lastSessionID;
    protected Set<String> memberOf = new HashSet<String>();

    public UserCredential(String user, String password) {
        this.user = user;
        this.password = password;
        this.active = true;
    }

    public UserCredential(IUserCredential userCredential) {
        this.updateObject(userCredential);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    @Override
    public void setUserName(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getLastSessionID() {
        return this.lastSessionID;
    }

    @Override
    public void setLastSessionID(String lastSessionID) {
        this.lastSessionID = lastSessionID;
    }

    @Override
    public Set<String> getGroupIDs() {
        return this.memberOf;
    }

    @Override
    public void joinGroup(String groupID) {
        this.memberOf.add(groupID);
    }

    @Override
    public void leaveGroup(String groupID) {
        this.memberOf.remove(groupID);
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return UserCredentialIdentifier.generateURI(this.getUserName(), applicationID, host);
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof IUserCredential && !objectInstance.equals(this)) {
            IUserCredential uc = (IUserCredential)objectInstance;
            this.active = uc.isActive();
            this.user = uc.getUserName();
            this.password = uc.getPassword();
            this.lastSessionID = uc.getLastSessionID();
            this.memberOf.clear();
            this.memberOf.addAll(uc.getGroupIDs());
            return true;
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        if (!(objectInstance instanceof IUserCredential)) {
            return false;
        }
        IUserCredential uc = (IUserCredential)objectInstance;
        boolean equal = this.user.equals(uc.getUserName());
        equal &= this.active == uc.isActive();
        equal &= this.password.equals(uc.getPassword());
        equal &= this.lastSessionID.equals(uc.getLastSessionID());
        if (equal &= this.getGroupIDs().size() == uc.getGroupIDs().size()) {
            Set<String> grps = this.getGroupIDs();
            for (String m : uc.getGroupIDs()) {
                equal &= grps.contains(m);
            }
        }
        return equal;
    }
}

