/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.transmission;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.ProgressResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.transceiver.transmission.Progress;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import java.net.URI;

public class Transmission
extends TransmissionObject
implements ITransmission {
    private static final long serialVersionUID = -3615408611962890824L;
    private final long creationTimestamp = System.currentTimeMillis();
    private Result result = null;
    private long resultTimestamp;
    private Progress progress = null;

    public Transmission(ITransmission transmission) {
        super(transmission.getTransmissionObject());
    }

    public Transmission(TransmissionObject transmissionObject) {
        super(transmissionObject);
    }

    @Override
    public TransmissionObject getTransmissionObject() {
        return this;
    }

    @Override
    public String getTransmissionId() {
        return String.valueOf(this.getTransmissionObject().getID());
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public void setResult(Result result) {
        if (this.result == null) {
            this.result = result;
            this.resultTimestamp = System.currentTimeMillis();
            if (this.progress == null && this.result instanceof ProgressResult) {
                ProgressResult progressResult = (ProgressResult)this.result;
                this.progress = new Progress(progressResult.progressID);
            }
        }
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public long getResultTimestamp() {
        return this.resultTimestamp;
    }

    @Override
    public int compareTo(ITransmission o) {
        long timeDifference = o.getCreationTimestamp() - this.getCreationTimestamp();
        if (timeDifference < 0L) {
            timeDifference = -1L;
        } else if (timeDifference > 0L) {
            timeDifference = 1L;
        }
        return (int)timeDifference;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return TransmissionIdentifier.generateURI(this.getID(), applicationID, host);
    }

    @Override
    public Progress getProgress() {
        return this.progress;
    }

    @Override
    public boolean hasProgress() {
        return this.progress != null;
    }

    public String toString() {
        return "Transmission [creationTimestamp=" + this.creationTimestamp + ", result=" + this.result + ", resultTimestamp=" + this.resultTimestamp + ", progress=" + this.progress + "]";
    }
}

