/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.state;

import bsc.api.transport.model.Caps;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.IExtension;
import bsc.sdk.api.extension.manager.IExtensionManager;
import bsc.sdk.api.notification.objects.AddMetaData;
import bsc.sdk.api.transceiver.state.ATransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AStateInit
extends ATransceiverState {
    private Map<String, String> capsMetaData;

    public AStateInit(StateConfiguration stateSettings) {
        super(stateSettings);
        this.capsMetaData = stateSettings.getMetaInformations();
    }

    protected Caps getCaps() {
        Caps c = new Caps();
        c.setProtocols(this.environment.getSettings().getProtocols());
        c.setEncryptions(this.environment.getSettings().getEncryptions());
        c.setCompressions(this.environment.getSettings().getCompressions());
        c.setApiVersions(this.environment.getSettings().getApiVersions());
        c.setApiExtensions(this.getExtensionList());
        this.fireNotification(new AddMetaData(c));
        return c;
    }

    private List<String> getExtensionList() {
        Set<IExtension> extensions;
        IExtensionManager manager;
        ArrayList<String> result = new ArrayList<String>();
        Environment settings = this.environment;
        if (settings != null && (manager = settings.getExtensionManager()) != null && (extensions = manager.getRegisteredExtensions()) != null) {
            for (IExtension extension : extensions) {
                if (!extension.isEnabled() || extension.isInternalExtension()) continue;
                result.add(extension.getExtensionId());
            }
        }
        return result;
    }

    public Map<String, String> getCapsMetaData() {
        return this.capsMetaData;
    }

    protected void setCapsMetaData(Map<String, String> metaData) {
        this.capsMetaData = metaData;
    }
}

