/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.manager;

import bsc.api.IApiObject;
import bsc.api.basic.commands.Command;
import bsc.sdk.api.AManager;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.settings.ServerSettings;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.notification.transceiver.TransceiversConnected;
import bsc.sdk.api.notification.user.UserConnectionStatus;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.ITransceiverManager;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.ISessionManager;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ATransceiverManager
extends AManager<TransceiverIdentifier, ITransceiver>
implements ITransceiverManager {
    protected ServerSettings serverSettings = null;
    protected Map<String, TransceiverController> controllerCache = new ConcurrentHashMap<String, TransceiverController>();
    protected Map<String, SessionIdentifier> transceiverSessions = new ConcurrentHashMap<String, SessionIdentifier>();
    protected int openConnections = 0;
    protected Map<String, Integer> openUserConnections = new HashMap<String, Integer>();

    @Override
    public void stateChanged(ITransceiver transceiver, ITransceiver.TransceiverState state) {
        TransceiverIdentifier transceiverIdentifier = (TransceiverIdentifier)this.getIdentifierInstance(transceiver);
        IUserCredential user = null;
        switch (state) {
            case CONNECTED: {
                this.addTransceiver(transceiver);
                break;
            }
            case DISCONNECTED: {
                this.removeTransceiver(transceiver);
                ISession session = this.getSession(this.transceiverSessions.get(transceiverIdentifier.getFullQualifiedIdentifiableString()));
                if (session == null) break;
                this.transceiverSessions.remove(transceiverIdentifier.getFullQualifiedIdentifiableString());
                try {
                    user = this.getUserCredential(UserCredentialIdentifier.createIdentifierInstance(session.getUserCredentialID(), this.getEnvironment()));
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (user == null) break;
                this.fireUserStatusChanged(user);
                break;
            }
            case READY: {
                user = this.getUserCredential(transceiver);
                if (user == null) break;
                TransceiverController controller = this.getTransceiverControllerInstance(transceiverIdentifier);
                if (controller != null) {
                    this.transceiverSessions.put(transceiverIdentifier.getFullQualifiedIdentifiableString(), controller.getCurrentSessionID());
                }
                this.fireUserStatusChanged(user);
            }
        }
        int connectedTransceivers = this.getConnectedTransceivers();
        if (this.openConnections != connectedTransceivers) {
            this.openConnections = connectedTransceivers;
            this.fireNotification(new TransceiversConnected(this.openConnections));
        }
    }

    private void fireUserStatusChanged(IUserCredential user) {
        String userName = user.getUserName();
        int cCount = this.getOpenConnectionSlotCount((UserCredentialIdentifier)this.getEnvironment().getUserCredentialManager().getIdentifierInstance(user));
        if (!this.openUserConnections.containsKey(userName) || this.openUserConnections.get(userName) != cCount) {
            this.openUserConnections.put(userName, cCount);
            this.fireNotification(new UserConnectionStatus(userName, cCount));
        }
    }

    protected ISession getSession(SessionIdentifier sessionIdentifier) {
        return (ISession)this.getEnvironment().getSessionManager().getObjectInstance(sessionIdentifier);
    }

    protected IUserCredential getUserCredential(UserCredentialIdentifier userCredentialIdentifier) {
        return (IUserCredential)this.getEnvironment().getUserCredentialManager().getObjectInstance(userCredentialIdentifier);
    }

    protected IUserCredential getUserCredential(ITransceiver transceiver) {
        return this.getUserCredential((TransceiverIdentifier)this.getIdentifierInstance(transceiver));
    }

    protected IUserCredential getUserCredential(TransceiverIdentifier transceiverIdentifier) {
        IUserCredential result = null;
        TransceiverController controller = this.getTransceiverControllerInstance(transceiverIdentifier);
        if (controller == null) {
            return result;
        }
        ISession session = (ISession)this.getEnvironment().getSessionManager().getObjectInstance(controller.getCurrentSessionID());
        if (session != null) {
            try {
                result = (IUserCredential)this.getEnvironment().getUserCredentialManager().getObjectInstance(UserCredentialIdentifier.createIdentifierInstance(session.getUserCredentialID(), this.getEnvironment()));
            }
            catch (URISyntaxException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private TransceiverIdentifier addTransceiver(ITransceiver transceiver) {
        TransceiverIdentifier identifier = (TransceiverIdentifier)this.addObject(transceiver);
        this.controllerCache.put(identifier.getFullQualifiedIdentifiableString(), new TransceiverController(transceiver));
        return identifier;
    }

    private TransceiverIdentifier removeTransceiver(ITransceiver transceiver) {
        this.freeID(transceiver.getTransceiverID());
        TransceiverIdentifier identifier = (TransceiverIdentifier)this.getIdentifierInstance(transceiver);
        this.getEnvironment().getExtensionManager().unSubscribe(identifier);
        this.removeObject(identifier);
        this.controllerCache.remove(identifier.getFullQualifiedIdentifiableString());
        this.getEnvironment().getIdPoolManager().removePool("ChannelHandlerSeq_" + transceiver.getTransceiverID());
        return identifier;
    }

    @Override
    public void errorOccurred(ITransceiver transceiver, TransceiverException transceiverException) {
        this.logger.error(transceiverException.getMessage(), (Throwable)transceiverException);
    }

    private int getConnectedTransceivers() {
        return this.objects.size();
    }

    @Override
    public List<ITransceiver> getTransceiverList() {
        ArrayList<ITransceiver> list = new ArrayList<ITransceiver>();
        list.addAll(this.objects.values());
        return list;
    }

    @Override
    public void disconnectAll() {
        for (ITransceiver iTransceiver : this.objects.values()) {
            if (iTransceiver == null) continue;
            iTransceiver.disconnect(false);
        }
    }

    @Override
    public void disconnect(UserCredentialIdentifier user) {
        if (user == null) {
            return;
        }
        ISessionManager sessionManager = this.getEnvironment().getSessionManager();
        for (Map.Entry iTransceiverEntry : this.objects.entrySet()) {
            SessionIdentifier sessionID;
            ISession session;
            TransceiverIdentifier transceiverIdentifier = (TransceiverIdentifier)this.getIdentifierInstance((String)iTransceiverEntry.getKey());
            if (transceiverIdentifier == null || !(session = (ISession)sessionManager.getObjectInstance(sessionID = this.getTransceiverControllerInstance(transceiverIdentifier).getCurrentSessionID())).getUserCredentialID().equals(user.getUserCredentialID())) continue;
            ((ITransceiver)iTransceiverEntry.getValue()).disconnect(false);
        }
    }

    @Override
    public boolean disconnect(SessionIdentifier session) {
        if (session == null) {
            return false;
        }
        for (Map.Entry iTransceiverEntry : this.objects.entrySet()) {
            SessionIdentifier sessionID;
            TransceiverIdentifier transceiverIdentifier = (TransceiverIdentifier)this.getIdentifierInstance((String)iTransceiverEntry.getKey());
            if (transceiverIdentifier == null || !(sessionID = this.getTransceiverControllerInstance(transceiverIdentifier).getCurrentSessionID()).getSessionID().equals(session.getSessionID())) continue;
            ((ITransceiver)iTransceiverEntry.getValue()).disconnect(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOpenConnectionSlots() {
        return this.getOpenConnectionSlotCount() < this.serverSettings.getMaxGlobalConnectionSlots();
    }

    @Override
    public boolean hasOpenConnectionSlots(UserCredentialIdentifier user) {
        return this.getOpenConnectionSlotCount(user) < this.serverSettings.getMaxUserConnectionSlots();
    }

    @Override
    public TransceiverController getTransceiverControllerInstance(TransceiverIdentifier identifier) {
        return this.controllerCache.get(identifier.getFullQualifiedIdentifiableString());
    }

    @Override
    public int getOpenConnectionSlotCount() {
        int count = 0;
        for (TransceiverController c : this.controllerCache.values()) {
            if (!c.isAuthenticated()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getOpenConnectionSlotCount(UserCredentialIdentifier user) {
        int count = 0;
        for (TransceiverController c : this.getTransceiverControllerForUser(user)) {
            if (!c.isAuthenticated()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void sendCommandToClient(Command command, UserCredentialIdentifier user) {
        for (TransceiverController controller : this.getTransceiverControllerForUser(user)) {
            controller.sendCommand(command);
        }
    }

    @Override
    public List<TransceiverController> getTransceiverControllersForSession(SessionIdentifier session) {
        ArrayList<TransceiverController> result = new ArrayList<TransceiverController>();
        String sessionID = session.getSessionID();
        ArrayList<TransceiverController> controllers = new ArrayList<TransceiverController>(this.controllerCache.values());
        for (TransceiverController transceiverController : controllers) {
            String cSessionID;
            String string = cSessionID = transceiverController.getCurrentSessionID() == null ? null : transceiverController.getCurrentSessionID().getSessionID();
            if (sessionID == null || !sessionID.equals(cSessionID)) continue;
            result.add(transceiverController);
        }
        return result;
    }

    protected List<TransceiverController> getTransceiverControllerForUser(UserCredentialIdentifier user) {
        IUserCredential uThis;
        ArrayList<TransceiverController> controllers = new ArrayList<TransceiverController>();
        if (this.getEnvironment() != null && this.getEnvironment().getUserCredentialManager() != null && (uThis = (IUserCredential)this.getEnvironment().getUserCredentialManager().getObjectInstance(user)) != null) {
            ISessionManager sessionManager = this.getEnvironment().getSessionManager();
            for (ITransceiver iTransceiver : this.getTransceiverList()) {
                ISession session;
                SessionIdentifier sessionIdentifier;
                TransceiverController controller;
                TransceiverIdentifier transceiverIdentifier = (TransceiverIdentifier)this.getIdentifierInstance(iTransceiver);
                if (transceiverIdentifier == null || (controller = this.getTransceiverControllerInstance(transceiverIdentifier)) == null || (sessionIdentifier = controller.getCurrentSessionID()) == null || (session = sessionIdentifier.getObjectInstance()) == null || session == null) continue;
                UserCredentialIdentifier userCredentialIdentifier = null;
                try {
                    userCredentialIdentifier = UserCredentialIdentifier.createIdentifierInstance(session.getUserCredentialID(), this.getEnvironment());
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (userCredentialIdentifier == null) continue;
                IUserCredential uExt = userCredentialIdentifier.getObjectInstance();
                if (!uThis.getUserName().equals(uExt.getUserName())) continue;
                controllers.add(controller);
            }
        }
        return controllers;
    }

    @Override
    protected ITransceiver getNewObjectInstance(ITransceiver orgObject) {
        return orgObject;
    }

    @Override
    public boolean isOpenConnections() {
        return this.openConnections > 0;
    }

    @Override
    public void sendObjectToClient(IApiObject object, UserCredentialIdentifier user) {
        if (object == null) {
            return;
        }
        for (TransceiverController controller : this.getTransceiverControllerForUser(user)) {
            controller.sendObject(object);
        }
    }

    @Override
    public void init(Environment environment) {
        super.init(environment);
        if (environment.getSettings() instanceof ServerSettings) {
            this.serverSettings = (ServerSettings)environment.getSettings();
        }
    }

    @Override
    public String getUniqueTransceiverID() {
        return this.getUniqueID();
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }

    @Override
    public boolean isConnected(SessionIdentifier session) {
        for (SessionIdentifier sessionIdentifier : this.transceiverSessions.values()) {
            if (!sessionIdentifier.equals(session)) continue;
            return true;
        }
        return false;
    }
}

