/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.controller;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.IMetaInformation;
import bsc.api.basic.commands.Command;
import bsc.api.basic.commands.offer.AOffer;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ASensor;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.qos.QoSMode;
import bsc.api.modules.qos.model.QoSConfiguration;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.commands.ConnectionRequest;
import bsc.api.transport.model.Caps;
import bsc.api.transport.result.ObjectResult;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.crypt.CipherException;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.api.notification.transceiver.TransceiverStatus;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.controller.IObjectValidator;
import bsc.sdk.api.transceiver.controller.qos.DynamicQoSFactory;
import bsc.sdk.api.transceiver.controller.qos.IDynamicQoS;
import bsc.sdk.api.transceiver.controller.qos.LatencyChecker;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import bsc.sdk.tools.Tools;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ATransceiverController
implements ITransceiverListener {
    public static final int defaultConnectionMonitorInterval = 15;
    private static int connectionMonitorIntervalForNewInstances = 15;
    protected static Logger logger = LoggerFactory.getLogger(ATransceiverController.class);
    private final ITransceiver transceiver;
    private final TransceiverIdentifier transceiverIdentifier;
    private SessionIdentifier currentSessionID;
    private final IDynamicQoS qos;
    private QoSConfiguration remoteQoSConfiguration;
    private final InetSocketAddress remoteAddress;
    private Set<IObjectValidator> objectValidator = new HashSet<IObjectValidator>();
    private Map<String, Integer> blacklistCount = new HashMap<String, Integer>();
    private final DynamicScheduledCachedThreadPoolExecutor executorService;
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask = null;
    private double throughputIn = 0.0;
    private double throughputOut = 0.0;
    private long updateTimestamp;
    private long inBytes = 0L;
    private long outBytes = 0L;
    private int connectionMonitorInterval;

    public ATransceiverController(ITransceiver transceiver) {
        this.transceiver = Objects.requireNonNull(transceiver, "transceiver must not be null!");
        this.executorService = this.transceiver.getEnvironment().getApplication().getExecutorServiceBackgroundTasks();
        this.transceiver.addTransceiverListener(this);
        this.transceiverIdentifier = (TransceiverIdentifier)this.transceiver.getEnvironment().getTransceiverManager().getIdentifierInstance(this.transceiver);
        this.remoteAddress = this.transceiver.getRemoteAddress();
        this.objectValidator = this.getEnvironment().getExtensionManager().getObjectValidatorSet();
        this.qos = DynamicQoSFactory.createNewInstance(this);
    }

    private void enableConnectionMonitor() {
        if (this.scheduledTask == null) {
            logger.trace(this.transceiverIdentifier.getTransceiverID() + " | Enable connection monitoring");
            int initdelay = this.connectionMonitorInterval * 1000 + Tools.getRandomNumberInRange(0, 1000);
            int delay = this.connectionMonitorInterval * 1000 + Tools.getRandomNumberInRange(0, 1000);
            try {
                this.scheduledTask = this.executorService.scheduleAtFixedDelay(new ConnectionMonitor(this), initdelay, delay, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.scheduledTask = null;
            }
        }
    }

    private void disableConnectionMonitor() {
        if (this.scheduledTask != null) {
            logger.trace(this.transceiverIdentifier.getTransceiverID() + " | Disable connection monitoring");
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    public ITransceiver getTransceiver() {
        return this.transceiver;
    }

    public TransmissionIdentifier write(TransmissionObject transmissionObject, ChannelWorker.WriteMode ... writeModes) {
        return this.write(transmissionObject, true, writeModes);
    }

    public TransmissionIdentifier write(TransmissionObject transmissionObject, boolean notifyTransmissionManager, ChannelWorker.WriteMode ... writeModes) {
        TransmissionObject transmissionClone = Tools.deepClone(transmissionObject);
        this.removeInvalidObjectData(transmissionClone);
        return this.transceiver.write(transmissionClone, notifyTransmissionManager, writeModes);
    }

    @Deprecated
    public void writeCustomHeader(byte[] header) {
        this.transceiver.writeCustomHeader(header);
    }

    public TransmissionObject nextIncomingTransmission() {
        return this.transceiver.nextIncomingTransmission();
    }

    public void fireStateChanged(ITransceiver.TransceiverState state) {
        this.transceiver.fireStateChanged(state);
    }

    public void initialize(SessionIdentifier currentSessionID) throws CipherException {
        this.currentSessionID = currentSessionID;
        this.transceiver.initialize(currentSessionID);
    }

    public void handleResult(TransmissionObject transmissionObject) {
        this.transceiver.handleResult(transmissionObject);
    }

    public FutureTransmission sendCommand(Command command) {
        return this.sendCommand(command, true);
    }

    public FutureTransmission sendCommand(Command command, boolean useQoS) {
        if (useQoS) {
            return this.qos.sendCommand(command);
        }
        return new FutureTransmission(this.transceiver.sendCommand(command));
    }

    public FutureTransmission sendObject(IApiObject object) {
        return this.sendObject(object, true);
    }

    public FutureTransmission sendObject(IApiObject object, boolean useQoS) {
        return this.sendObject(object, useQoS, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FutureTransmission sendObject(IApiObject object, boolean useQoS, boolean skipValidation, boolean cloneObject) {
        ASensor sensor;
        if (object == null) {
            logger.debug("Object to send is null! Skip sending!");
            return null;
        }
        logger.debug("Send object (QoS=" + useQoS + " skipValidation=" + skipValidation + " cloneObject=" + cloneObject + "): " + object.getClass().getName());
        IApiObject objectInstance = null;
        if (cloneObject && object instanceof IIdentifiableApiObject) {
            IApiObject iApiObject = object;
            synchronized (iApiObject) {
                objectInstance = Tools.deepClone(object);
            }
        } else {
            objectInstance = object;
        }
        if (!skipValidation && !this.isObjectValidForTransceiver(objectInstance)) {
            return null;
        }
        this.removeInvalidObjectData(objectInstance);
        if (useQoS) {
            return this.qos.sendObject(objectInstance);
        }
        if (objectInstance instanceof ASensor && (sensor = (ASensor)objectInstance).getCommandOffers().isEmpty()) {
            SensorIdentifier si = (SensorIdentifier)this.getEnvironment().getObjectManager().getIdentifierInstance(sensor);
            Integer count = this.blacklistCount.get(si.getFullQualifiedIdentifiableString());
            if (count == null) {
                this.blacklistCount.put(si.getFullQualifiedIdentifiableString(), 1);
                System.out.println("TRIGGER REBUILD");
                si.rebuildUserObjectCache(this.getCurrentSessionID().getUserCredentialIdentifier());
            } else if (count < 1000) {
                this.blacklistCount.put(si.getFullQualifiedIdentifiableString(), count + 1);
                System.out.println("TRIGGER REBUILD");
                si.rebuildUserObjectCache(this.getCurrentSessionID().getUserCredentialIdentifier());
            }
        }
        return new FutureTransmission(this.transceiver.sendObject(objectInstance));
    }

    private void removeInvalidObjectData(IApiObject object) {
        if (object == null) {
            return;
        }
        if (object instanceof ISensor) {
            this.removeInvalidSensorData((ISensor)object);
        } else if (object instanceof ADevice) {
            this.removeInvalidDeviceData((ADevice)object);
        } else if (object instanceof ObjectContainer) {
            ObjectContainer container = (ObjectContainer)object;
            Iterator itr = container.getObjects().iterator();
            while (itr.hasNext()) {
                this.removeInvalidObjectData((IApiObject)itr.next());
            }
        } else if (object instanceof ObjectResult) {
            ObjectResult result = (ObjectResult)object;
            this.removeInvalidObjectData(result.getObject());
        } else if (object instanceof TransmissionObject) {
            TransmissionObject transmissionObject = (TransmissionObject)object;
            this.removeInvalidObjectData(transmissionObject.getObject());
        }
        if (object instanceof IMetaInformation) {
            this.removeInvalidMetaInformations((IMetaInformation)((Object)object));
        }
    }

    private void removeInvalidMetaInformations(IMetaInformation object) {
        if (object == null || object instanceof ConnectionRequest || object instanceof Caps) {
            return;
        }
        Set<String> subscriptions = this.getTransceiverIdentifier().getSubscriptionList();
        for (String key : object.getAllMetaInformations().keySet()) {
            String extensionID;
            boolean valid = false;
            Iterator<String> i$ = subscriptions.iterator();
            while (i$.hasNext() && !(valid = key.startsWith(extensionID = i$.next()))) {
            }
            if (valid) continue;
            logger.trace("Removed invalid meta information with key: " + key);
            object.removeMetaInformation(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidDeviceData(ADevice device) {
        if (device == null) {
            return;
        }
        ADevice aDevice = device;
        synchronized (aDevice) {
            Iterator<ISensor> sensorItr = device.getSensors().iterator();
            while (sensorItr.hasNext()) {
                ISensor sensor = sensorItr.next();
                if (!this.isObjectValidForTransceiver(sensor)) {
                    logger.trace("Removed invalid sensor: " + sensor.getClass().getName());
                    sensorItr.remove();
                    continue;
                }
                this.removeInvalidObjectData(sensor);
            }
        }
        Iterator<AOffer<?>> offerItr = device.getCommandOffers().iterator();
        while (offerItr.hasNext()) {
            AOffer<?> offer = offerItr.next();
            if (this.isObjectValidForTransceiver(offer)) continue;
            logger.trace("Removed invalid device offer: " + offer.getClass().getName());
            offerItr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidSensorData(ISensor sensor) {
        if (sensor == null) {
            return;
        }
        ISensor iSensor = sensor;
        synchronized (iSensor) {
            Iterator<AOffer<?>> offerItr = sensor.getCommandOffers().iterator();
            while (offerItr.hasNext()) {
                AOffer<?> offer = offerItr.next();
                if (this.isObjectValidForTransceiver(offer)) continue;
                logger.trace("Removed invalid sensor offer: " + offer.getClass().getName());
                offerItr.remove();
            }
        }
    }

    private boolean isObjectValidForTransceiver(IApiObject object) {
        boolean result;
        boolean bl = result = object != null;
        if (result) {
            for (IObjectValidator validator : this.objectValidator) {
                logger.trace("Validate object: " + object.toString());
                result = validator.validateObject(this, object);
                if (result) continue;
                break;
            }
        }
        return result;
    }

    public void exit() {
        this.transceiver.exit();
    }

    public void disconnect(boolean terminate) {
        this.transceiver.disconnect(terminate);
    }

    public void closeChannel() {
        this.transceiver.closeChannel();
    }

    public void printStatistics() {
        this.transceiver.printStatistics();
    }

    public void error(TransceiverException transceiverException) {
        this.transceiver.error(transceiverException);
    }

    public SessionIdentifier getCurrentSessionID() {
        return this.currentSessionID;
    }

    public void fireNotification(INotification notification) {
        if (this.getEnvironment() != null) {
            this.getEnvironment().getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)notification);
        }
    }

    public void shutdownAfterSending(IApiObject apiObject) {
        this.transceiver.shutdownAfterSending(apiObject);
    }

    public void setQoSMode(QoSMode mode) {
        this.qos.setMode(mode);
    }

    public QoSMode getQoSMode() {
        return this.qos.getMode();
    }

    public void setQoSUpdateIntervalObjects(int updateIntervalObjects) {
        this.qos.setUpdateIntervalObjects(updateIntervalObjects);
    }

    public int getQoSUpdateIntervalObjects() {
        return this.qos.getUpdateIntervalObjects();
    }

    public void setQoSUpdateIntervalFrames(int updateIntervalFrames) {
        this.qos.setUpdateIntervalFrames(updateIntervalFrames);
    }

    public int getQoSUpdateIntervalFrames() {
        return this.qos.getUpdateIntervalFrames();
    }

    public void setQoSDeviceWhitelist(Collection<String> deviceIDs) {
        this.qos.setDeviceWhitelist(deviceIDs);
    }

    public void setQoSGroupWhitelist(Collection<Integer> groupIDs) {
        this.qos.setGroupWhitelist(groupIDs);
    }

    public QoSConfiguration getQoSConfiguration() {
        return this.qos.getQoSConfiguration();
    }

    public void flushQoSPendingUpdates() {
        this.qos.flushPendingUpdates();
    }

    public TransceiverIdentifier getTransceiverIdentifier() {
        return this.transceiverIdentifier;
    }

    public Environment getEnvironment() {
        return this.transceiver.getEnvironment();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void stateChanged(ITransceiver transceiver, ITransceiver.TransceiverState state) {
        switch (state) {
            case CONNECTED: {
                break;
            }
            case DISCONNECTED: {
                this.disableConnectionMonitor();
                break;
            }
            case READY: {
                this.enableConnectionMonitor();
            }
        }
        this.fireNotification(new TransceiverStatus(this, state));
    }

    @Override
    public void errorOccurred(ITransceiver transceiver, TransceiverException transceiverException) {
    }

    public double getThroughputIn() {
        return this.throughputIn;
    }

    public double getThroughputOut() {
        return this.throughputOut;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public long getInBytes() {
        return this.inBytes;
    }

    public long getOutBytes() {
        return this.outBytes;
    }

    public long getAverageLatency() {
        return this.qos.getAverageLatency();
    }

    public int getConnectionMonitorInterval() {
        return this.connectionMonitorInterval;
    }

    public void setConnectionMonitorInterval(int connectionMonitorInterval) {
        if (this.connectionMonitorInterval != connectionMonitorInterval && connectionMonitorInterval > 0) {
            connectionMonitorIntervalForNewInstances = connectionMonitorInterval;
            this.connectionMonitorInterval = connectionMonitorInterval;
            this.disableConnectionMonitor();
            this.enableConnectionMonitor();
        }
    }

    public IDynamicQoS getQos() {
        return this.qos;
    }

    public boolean isAuthenticated() {
        return this.transceiver.isAuthenticated();
    }

    public QoSConfiguration getRemoteQoSConfiguration() {
        return this.remoteQoSConfiguration;
    }

    public void setRemoteQoSConfiguration(QoSConfiguration remoteQoSConfiguration) {
        this.remoteQoSConfiguration = remoteQoSConfiguration;
    }

    private class ConnectionMonitor
    extends LatencyChecker {
        private final long timeout;
        private long threshold;

        public ConnectionMonitor(ATransceiverController controller) {
            super(controller, 1);
            this.timeout = TimeUnit.SECONDS.toMillis(55L);
            ATransceiverController.this.connectionMonitorInterval = connectionMonitorIntervalForNewInstances;
            ATransceiverController.this.inBytes = controller.getTransceiver().getInBytes();
            ATransceiverController.this.outBytes = controller.getTransceiver().getOutBytes();
            ATransceiverController.this.updateTimestamp = System.currentTimeMillis();
            this.threshold = System.currentTimeMillis() + this.timeout;
        }

        @Override
        public void run() {
            boolean somethingChanged;
            long newInBytes = this.controller.getTransceiver().getInBytes();
            long newOutBytes = this.controller.getTransceiver().getOutBytes();
            boolean bl = somethingChanged = newInBytes != ATransceiverController.this.inBytes || newOutBytes != ATransceiverController.this.outBytes;
            if (somethingChanged) {
                long monitoredTime = System.currentTimeMillis() - ATransceiverController.this.updateTimestamp;
                ATransceiverController.this.throughputIn = (double)(newInBytes - ATransceiverController.this.inBytes) / (double)monitoredTime * (double)TimeUnit.SECONDS.toMillis(1L);
                ATransceiverController.this.inBytes = newInBytes;
                ATransceiverController.this.throughputOut = (double)(newOutBytes - ATransceiverController.this.outBytes) / (double)monitoredTime * (double)TimeUnit.SECONDS.toMillis(1L);
                ATransceiverController.this.outBytes = newOutBytes;
                ATransceiverController.this.updateTimestamp = System.currentTimeMillis();
                this.threshold = ATransceiverController.this.updateTimestamp + this.timeout;
            } else if (System.currentTimeMillis() > this.threshold || this.getAverageLatency() == 0L) {
                super.run();
            }
            if (this.getAverageLatency() == LatencyChecker.timeout && newInBytes == ATransceiverController.this.inBytes) {
                this.logger.warn("Inactive transceiver detected! Disconnecting transceiver: " + this.controller.getTransceiverIdentifier().getTransceiverID());
                ATransceiverController.this.disconnect(true);
            }
        }
    }
}

