/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.protocol.ProtocolFactory;
import bsc.sdk.api.transceiver.AChannelHandler;
import bsc.sdk.api.transceiver.ATransceiver;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHandlerAsync
extends AChannelHandler {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandlerAsync.class);
    private AsynchronousSocketChannel clientChannel;
    private FutureBuffer futureBuffer;

    public ChannelHandlerAsync(AsynchronousSocketChannel channel, ExecutorService executorService) {
        this.clientChannel = channel;
        this.protocol = ProtocolFactory.newInstance(Enumerations.ProtocolType.JSON);
        this.executorService = executorService;
    }

    private boolean readyToProcessFutures() throws Throwable {
        if (this.futureBuffer == null) {
            return true;
        }
        if (!this.futureBuffer.future.isDone()) {
            return false;
        }
        Future read = this.futureBuffer.future;
        ByteBuffer buffer = this.futureBuffer.buffer;
        int nBytes = (Integer)read.get();
        if (nBytes == -1) {
            throw new TransceiverException(Enumerations.ErrorType.END_OF_STREAM_REACHED, "received -1");
        }
        this.inBytes += (long)nBytes;
        buffer.flip();
        byte[] bytes = buffer.array();
        for (int i = 0; i < nBytes; ++i) {
            this.readByteBuffer.add(bytes[i]);
        }
        buffer.clear();
        this.buildTransmissionObject();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTransmissionObject() {
        block9: {
            try {
                ATransceiver.DataPacket dataPacket = new ATransceiver.DataPacket();
                this.readDataPacket(this.readByteBuffer, dataPacket);
                if (dataPacket.data == null) break block9;
                TransmissionObject transmission = this.read(dataPacket, false);
                ConcurrentLinkedQueue concurrentLinkedQueue = this.incoming;
                synchronized (concurrentLinkedQueue) {
                    this.incoming.offer(transmission);
                    ExecutorService executorService = this.executorService;
                    synchronized (executorService) {
                        this.executorService.execute(this.transceiver);
                    }
                }
            }
            catch (Throwable t) {
                TransceiverException ex;
                Enumerations.ErrorType type;
                boolean endCommunication = false;
                if (t instanceof TransceiverException && ((type = (ex = (TransceiverException)t).getErrorType()) == Enumerations.ErrorType.UNEXPECTED_SEQUENCE || type == Enumerations.ErrorType.CIPHER_FAILED || type == Enumerations.ErrorType.UNKNOWN_ENCRYPTION || type == Enumerations.ErrorType.COMPRESSION_FAILED || type == Enumerations.ErrorType.UNKNOWN_COMPRESSION || type == Enumerations.ErrorType.UNSUPPORTED_API_VERSION || type == Enumerations.ErrorType.UNKNOWN_PROTOCOL || type == Enumerations.ErrorType.PROTOCOL_FAILED)) {
                    endCommunication = true;
                }
                this.sendErrorData(t, endCommunication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AChannelHandler.Op currentOp;
        Object object = this.ops;
        synchronized (object) {
            currentOp = (AChannelHandler.Op)((Object)this.ops.poll());
            if (currentOp == null) {
                return;
            }
        }
        switch (currentOp) {
            case READ: {
                object = this.readByteBuffer;
                synchronized (object) {
                    try {
                        if (this.readyToProcessFutures()) {
                            ByteBuffer buffer = ByteBuffer.allocate(32);
                            Future<Integer> read = this.clientChannel.read(buffer);
                            this.futureBuffer = new FutureBuffer();
                            this.futureBuffer.future = read;
                            this.futureBuffer.buffer = buffer;
                        }
                    }
                    catch (Throwable e) {
                        TransceiverException t = new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during reading from channel", e);
                        this.sendErrorData(t, true);
                        return;
                    }
                }
                object = this.ops;
                synchronized (object) {
                    this.ops.offer(AChannelHandler.Op.READ);
                    break;
                }
            }
            case WRITE: {
                object = this.writeByteBuffer;
                synchronized (object) {
                    try {
                        this.write();
                    }
                    catch (Throwable t) {
                        this.sendErrorData(t, true);
                        return;
                    }
                }
            }
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        object = this.executorService;
        synchronized (object) {
            this.executorService.execute(this);
        }
    }

    @Override
    public void closeChannel() {
        try {
            this.clientChannel.close();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public int writeData(List<Byte> writeByteBuffer) throws TransceiverException {
        if (writeByteBuffer.size() < 1) {
            return 0;
        }
        byte[] message = new byte[writeByteBuffer.size()];
        for (int i = 0; i < message.length; ++i) {
            message[i] = writeByteBuffer.get(i);
        }
        int writtenBytes = 0;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(message);
            Future<Integer> result = this.clientChannel.write(buffer);
            writtenBytes = result.get();
            for (int i = 0; i < writtenBytes; ++i) {
                writeByteBuffer.remove(0);
            }
            buffer.clear();
        }
        catch (Throwable e) {
            throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during writing", e);
        }
        return writtenBytes;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.clientChannel != null) {
            try {
                SocketAddress sa = this.clientChannel.getRemoteAddress();
                if (sa instanceof InetSocketAddress) {
                    return (InetSocketAddress)sa;
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private class FutureBuffer {
        private Future<Integer> future;
        private ByteBuffer buffer;

        private FutureBuffer() {
        }
    }
}

