/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.MultiObjectResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.crypt.CipherException;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.state.AStateExit;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.transmission.Transmission;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import bsc.sdk.tools.Tools;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATransceiver
implements ITransceiver,
Runnable {
    private static Logger logger = LoggerFactory.getLogger(ATransceiver.class);
    protected ChannelWorker channelHandler;
    private ITransceiverState state;
    private ConcurrentLinkedQueue<ITransceiverListener> transceiverListeners;
    private ExecutorService executorService;
    private boolean authenticated = false;
    private Environment environment = null;
    private IUserCredential connectedUser;
    private String id;
    private final long creationTime;
    private IApiObject lastObjectToSend;
    private Object stateLock = new Object();
    private final InetSocketAddress remoteAddress;
    private ITransceiver.TransceiverState currentState = ITransceiver.TransceiverState.DISCONNECTED;

    public ATransceiver(ChannelWorker channelWorker, Environment environment, ITransceiverState state) throws SocketException {
        this.creationTime = System.currentTimeMillis();
        this.transceiverListeners = new ConcurrentLinkedQueue();
        this.channelHandler = channelWorker;
        this.channelHandler.setTransceiver(this);
        this.executorService = channelWorker.getExecutorService();
        this.environment = environment;
        this.state = state;
        this.remoteAddress = channelWorker.getRemoteAddress();
        this.id = environment.getTransceiverManager().getUniqueTransceiverID();
    }

    public void setConnectedUser(IUserCredential connectedUser) {
        this.connectedUser = connectedUser;
    }

    public IUserCredential getConnectedUser() {
        return this.connectedUser;
    }

    @Override
    public void initialize(SessionIdentifier currentSessionID) throws CipherException {
        this.channelHandler.initialize(currentSessionID);
    }

    @Override
    public void setTransceiverState(ITransceiverState state) {
        int newStateLevel;
        int currentStateLevel = this.state != null ? this.state.getLevel() : 0;
        int n = newStateLevel = state != null ? state.getLevel() : 6;
        if (newStateLevel >= currentStateLevel) {
            this.state = state;
        }
    }

    @Override
    public TransmissionObject nextIncomingTransmission() {
        return this.channelHandler.nextIncomingTransmission();
    }

    @Override
    public void closeChannel() {
        this.channelHandler.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.state != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != null) {
                    this.setTransceiverState(this.state.execute());
                    while (this.state != null && this.state instanceof AStateExit) {
                        this.setTransceiverState(this.state.execute());
                    }
                }
            }
        }
    }

    @Override
    public void error(TransceiverException e) {
        this.fireErrorOccured(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean terminate) {
        Object object = this.stateLock;
        synchronized (object) {
            this.setTransceiverState(this.state.disconnect(terminate));
            ExecutorService executorService = this.executorService;
            synchronized (executorService) {
                this.executorService.execute(this);
            }
        }
    }

    @Override
    public void exit() {
        this.channelHandler.markAsShutdownInProgress();
        this.closeChannel();
        this.fireStateChanged(ITransceiver.TransceiverState.DISCONNECTED);
        logger.trace("ATransceiver (" + this.id + ") disconnected");
        this.printStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            this.executorService.execute(this);
        }
    }

    @Override
    public void shutdownAfterSending(IApiObject apiObject) {
        this.lastObjectToSend = apiObject;
    }

    public IApiObject getLastObjectToSend() {
        return this.lastObjectToSend;
    }

    @Override
    public void fireErrorOccured(TransceiverException e) {
        Iterator<ITransceiverListener> iterator = this.transceiverListeners.iterator();
        System.out.println("e " + e.getMessage());
        while (iterator.hasNext()) {
            ITransceiverListener clientListener = iterator.next();
            clientListener.errorOccurred(this, e);
        }
    }

    @Override
    public void fireStateChanged(ITransceiver.TransceiverState state) {
        this.currentState = state;
        boolean bl = this.authenticated = this.currentState == ITransceiver.TransceiverState.READY;
        if (this.authenticated) {
            this.channelHandler.setVerifyPacketApiRevision(true);
        }
        for (ITransceiverListener clientListener : this.transceiverListeners) {
            clientListener.stateChanged(this, state);
        }
    }

    @Override
    public void addTransceiverListener(ITransceiverListener listener) {
        if (listener != null && !this.transceiverListeners.contains(listener)) {
            this.transceiverListeners.add(listener);
        }
    }

    @Override
    public boolean removeTransceiverListener(ITransceiverListener listener) {
        return this.transceiverListeners.remove(listener);
    }

    @Override
    public TransmissionIdentifier write(TransmissionObject transmissionObject, ChannelWorker.WriteMode ... writeModes) {
        return this.write(transmissionObject, true, writeModes);
    }

    @Override
    public TransmissionIdentifier write(TransmissionObject transmissionObject, boolean notifyTransmissionManager, ChannelWorker.WriteMode ... writeModes) {
        TransmissionIdentifier identifier = null;
        if (notifyTransmissionManager && !(transmissionObject.getObject() instanceof Result)) {
            identifier = (TransmissionIdentifier)this.getEnvironment().getTransmissionManager().addObject(new Transmission(transmissionObject));
        }
        this.channelHandler.write(transmissionObject, writeModes);
        return identifier;
    }

    @Override
    @Deprecated
    public void writeCustomHeader(byte[] header) {
        try {
            this.channelHandler.writeData(this.channelHandler.asByteList(header));
        }
        catch (TransceiverException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.state.error(e);
        }
    }

    @Override
    public void printStatistics() {
        this.channelHandler.printStatistics();
    }

    @Override
    public void setCipher(ICipher cipher) {
        this.channelHandler.setCipher(cipher);
    }

    @Override
    public ICipher getCipher() {
        return this.channelHandler.getCipher();
    }

    @Override
    public void setCompression(ICompression compression) {
        this.channelHandler.setCompression(compression);
    }

    @Override
    public ICompression getCompression() {
        return this.channelHandler.getCompression();
    }

    @Override
    public void setProtocol(IProtocol protocol) {
        this.channelHandler.setProtocol(protocol);
    }

    @Override
    public IProtocol getProtocol() {
        return this.channelHandler.getProtocol();
    }

    @Override
    public void handleResult(TransmissionObject transmissionObject) {
        String transmissionID = transmissionObject.getID();
        Result result = (Result)transmissionObject.getObject();
        this.getEnvironment().getTransmissionManager().attachResult(transmissionID, result);
        if (result == null) {
            return;
        }
        ArrayList<IApiObject> objectsToHandle = new ArrayList<IApiObject>();
        if (transmissionObject.getObject() instanceof ObjectResult) {
            ObjectResult objectResult = (ObjectResult)transmissionObject.getObject();
            objectsToHandle.add(objectResult.getObject());
        } else if (transmissionObject.getObject() instanceof MultiObjectResult) {
            MultiObjectResult multiObjectResult = (MultiObjectResult)transmissionObject.getObject();
            objectsToHandle.addAll(multiObjectResult.getObjects());
        }
        for (IApiObject iApiObject : objectsToHandle) {
            this.getEnvironment().getHandleManager().handle((TransceiverIdentifier)this.getEnvironment().getTransceiverManager().getIdentifierInstance(this), iApiObject);
        }
    }

    @Override
    public TransmissionIdentifier sendCommand(Command command) {
        TransmissionObject transmissionObject = new TransmissionObject(this.getNewTransmissionId(), command);
        return this.write(transmissionObject, new ChannelWorker.WriteMode[0]);
    }

    @Override
    public TransmissionIdentifier sendObject(IApiObject object) {
        if (this.authenticated) {
            logger.debug("Send object: " + object.getClass().getName());
            TransmissionObject transmissionObject = null;
            transmissionObject = object instanceof TransmissionObject ? (TransmissionObject)object : new TransmissionObject(this.getNewTransmissionId(), object);
            return this.write(transmissionObject, new ChannelWorker.WriteMode[0]);
        }
        logger.debug("Failed to send: not authenticated");
        return null;
    }

    private String getNewTransmissionId() {
        return this.getEnvironment().getTransmissionManager().getUniqueTransmissionId();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getTransceiverID() {
        return this.id;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return TransceiverIdentifier.generateURI(this.getTransceiverID(), applicationID, host);
    }

    @Override
    public ITransceiverState getTransceiverState() {
        return this.state;
    }

    @Override
    public ChannelWorker getChannelHandler() {
        return this.channelHandler;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getInBytes() {
        return this.channelHandler.getInBytes();
    }

    @Override
    public long getOutBytes() {
        return this.channelHandler.getOutBytes();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public ITransceiver.TransceiverState getState() {
        return this.currentState;
    }

    public static final class ErrorData {
        int errorType;
        String message;

        public ErrorData(int errorType, String message) {
            this.errorType = errorType;
            this.message = message;
        }

        public byte[] toByteArray() throws TransceiverException {
            byte[] data = null;
            ByteArrayOutputStream bout = null;
            FilterOutputStream dout = null;
            try {
                bout = new ByteArrayOutputStream();
                dout = new DataOutputStream(bout);
                ((DataOutputStream)dout).writeInt(this.errorType);
                Tools.writeString((DataOutputStream)dout, this.message);
                ((DataOutputStream)dout).flush();
                data = bout.toByteArray();
            }
            catch (IOException e) {
                throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error occurred", e);
            }
            finally {
                try {
                    dout.close();
                    bout.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return data;
        }

        public String toString() {
            String className = this.getClass().getSimpleName();
            return MessageFormat.format("{0}: ErrorType = {1}, Message = {2}", className, this.errorType, this.message);
        }
    }

    public static final class DataPacket {
        public Enumerations.MessageType packetType;
        public byte[] data;
        public int sequence;
        public int apiRevision;

        public String toString() {
            String className = this.getClass().getSimpleName();
            return MessageFormat.format("{0}: PacketType = {1}, Data = [{2}]", new Object[]{className, this.packetType, Tools.toHexString(this.data)});
        }
    }
}

