/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.model.NotParsableObject;
import bsc.api.transport.result.FailResult;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.idpool.IdPoolSettings;
import bsc.sdk.api.compression.CompressionFactory;
import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.crypt.CipherFactory;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.compression.CompressionException;
import bsc.sdk.api.exception.compression.UnknownCompressionException;
import bsc.sdk.api.exception.crypt.CipherException;
import bsc.sdk.api.exception.crypt.UnknownEncryptionException;
import bsc.sdk.api.exception.protocol.ProtocolException;
import bsc.sdk.api.exception.protocol.UnknownProtocolException;
import bsc.sdk.api.exception.transceiver.RemoteException;
import bsc.sdk.api.exception.transceiver.UnknownMessageException;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.api.notification.state.ConnectionStatus;
import bsc.sdk.api.notification.transceiver.error.CriticalTransportError;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.api.protocol.ProtocolFactory;
import bsc.sdk.api.transceiver.ATransceiver;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import bsc.sdk.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AChannelHandler
implements Runnable,
ChannelWorker {
    private static Logger logger = LoggerFactory.getLogger(AChannelHandler.class);
    public static final String IDPOOL_PREFIX = "ChannelHandlerSeq_";
    protected boolean verifyPacketSequence = false;
    protected boolean verifyPacketApiRevision = false;
    protected ExecutorService executorService;
    protected ATransceiver transceiver;
    protected List<Byte> readByteBuffer = new ArrayList<Byte>();
    protected List<Byte> writeByteBuffer = new ArrayList<Byte>();
    protected ICipher cipher;
    protected ICompression compression;
    protected IProtocol protocol;
    protected Enumerations.EncryptionType encryptionType = Enumerations.EncryptionType.NONE;
    protected Enumerations.CompressionType compressionType = Enumerations.CompressionType.NONE;
    protected Enumerations.ProtocolType protocolType = Enumerations.ProtocolType.JSON;
    protected long inBytes = 0L;
    protected long outBytes = 0L;
    protected ConcurrentLinkedQueue<Op> ops = new ConcurrentLinkedQueue();
    private IdPool sequencePool;
    protected int apiRevision = 0;
    protected int expectedSequence = 1;
    private int currentSequenceId = 0;
    protected boolean shutdownInProgress;
    protected ConcurrentLinkedQueue<TransmissionObject> incoming = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<TransmissionContainer> outgoing = new ConcurrentLinkedQueue();
    protected final IProtocol JSON_PROTOCOL = ProtocolFactory.newInstance(Enumerations.ProtocolType.JSON);

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setTransceiver(ATransceiver transceiver) {
        this.transceiver = Objects.requireNonNull(transceiver, "Transceiver must not be null!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionObject nextIncomingTransmission() {
        TransmissionObject transmission;
        ConcurrentLinkedQueue<TransmissionObject> concurrentLinkedQueue = this.incoming;
        synchronized (concurrentLinkedQueue) {
            transmission = this.incoming.poll();
        }
        return transmission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionObject nextIncomingTransmission(String transmissionID) {
        TransmissionObject transmissionObject = null;
        ConcurrentLinkedQueue<TransmissionObject> concurrentLinkedQueue = this.incoming;
        synchronized (concurrentLinkedQueue) {
            for (TransmissionObject t : this.incoming) {
                if (!t.getID().equals(transmissionID)) continue;
                transmissionObject = t;
                break;
            }
            if (transmissionObject != null) {
                this.incoming.remove(transmissionObject);
            }
        }
        return transmissionObject;
    }

    @Override
    public void initialize(SessionIdentifier currentSessionID) throws CipherException {
        ISession session = currentSessionID.getObjectInstance();
        this.encryptionType = session.getEncryptionType();
        this.compressionType = session.getCompressionType();
        this.protocolType = session.getProtocolType();
        this.protocol = ProtocolFactory.newInstance(this.protocolType);
        this.cipher = CipherFactory.createNewInstance(this.encryptionType);
        byte[] sharedSecret = session.getSharedSecret();
        if (this.cipher != null) {
            this.cipher.setShared(sharedSecret);
        }
        this.compression = CompressionFactory.createNewInstance(this.compressionType);
    }

    @Override
    public IProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(IProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public ICompression getCompression() {
        return this.compression;
    }

    @Override
    public void setCompression(ICompression compression) {
        this.compression = compression;
    }

    @Override
    public ICipher getCipher() {
        return this.cipher;
    }

    @Override
    public void setCipher(ICipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public long getInBytes() {
        return this.inBytes;
    }

    @Override
    public long getOutBytes() {
        return this.outBytes;
    }

    @Override
    public void printStatistics() {
        logger.trace("#####################################");
        logger.trace(this.transceiver.getTransceiverID() + " statistics:");
        logger.trace("Out: " + this.outBytes + " Bytes");
        logger.trace("In: " + this.inBytes + " Bytes");
        logger.trace("All: " + (this.inBytes + this.outBytes) + " Bytes");
        logger.trace("#####################################");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.ops;
        synchronized (object) {
            this.ops.offer(Op.READ);
        }
        object = this.executorService;
        synchronized (object) {
            this.executorService.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TransmissionObject transmission, ChannelWorker.WriteMode ... writeModes) {
        Object object = this.outgoing;
        synchronized (object) {
            TransmissionContainer container = new TransmissionContainer();
            container.transmissionObject = transmission;
            if (writeModes.length == 0) {
                ArrayList<ChannelWorker.WriteMode> allModes = new ArrayList<ChannelWorker.WriteMode>();
                if (this.protocolType != null) {
                    allModes.add(ChannelWorker.WriteMode.PROTOCOL);
                }
                if (this.encryptionType != Enumerations.EncryptionType.NONE && this.encryptionType != null) {
                    allModes.add(ChannelWorker.WriteMode.ENCRYPTED);
                }
                if (this.compressionType != Enumerations.CompressionType.NONE && this.compressionType != null) {
                    allModes.add(ChannelWorker.WriteMode.COMPRESSED);
                }
                container.writeModes = allModes.toArray(new ChannelWorker.WriteMode[0]);
            } else {
                container.writeModes = writeModes;
            }
            this.outgoing.offer(container);
        }
        object = this.ops;
        synchronized (object) {
            this.ops.offer(Op.WRITE);
        }
        object = this.executorService;
        synchronized (object) {
            this.executorService.execute(this);
        }
    }

    protected String getDataAs(byte[] data, LogType type) {
        switch (type) {
            case STRING: {
                String log;
                try {
                    log = new String(data, "UTF-8");
                }
                catch (Throwable e) {
                    log = e instanceof UnsupportedEncodingException ? "UnsupportedEncoding Exception occurred" : "Exception while generating String";
                }
                return log;
            }
            case HEX: {
                return Tools.toHexString(data);
            }
        }
        return "";
    }

    private IdPool getSequencePool() {
        if (this.sequencePool == null) {
            IdPoolSettings settings = new IdPoolSettings(IDPOOL_PREFIX + this.transceiver.getTransceiverID(), IdPool.GENERATOR_TYPE.SEQUENCE_INT, 0L, "", "", 25, "", 0);
            this.sequencePool = this.transceiver.getEnvironment().getIdPoolManager().createNewPool(settings);
        }
        return this.sequencePool;
    }

    protected void writeContainer(TransmissionContainer container) throws TransceiverException {
        int i;
        byte[] data;
        if (container == null) {
            return;
        }
        ATransceiver.DataPacket dataPacket = new ATransceiver.DataPacket();
        dataPacket.packetType = Enumerations.MessageType.PROTOCOL;
        this.currentSequenceId = Integer.parseInt(this.getSequencePool().getId());
        this.getSequencePool().freeID(String.valueOf(this.currentSequenceId));
        TransmissionObject transmission = container.transmissionObject;
        transmission.setSequenceID(this.currentSequenceId);
        ChannelWorker.WriteMode[] writeModes = container.writeModes;
        Arrays.sort((Object[])writeModes);
        if (Arrays.binarySearch((Object[])writeModes, (Object)ChannelWorker.WriteMode.PROTOCOL) >= 0) {
            if (this.protocol == null) {
                throw new IllegalArgumentException("protocol hasn't been set yet.");
            }
            dataPacket.data = this.protocol.writeObject(transmission);
        }
        if (Arrays.binarySearch((Object[])writeModes, (Object)ChannelWorker.WriteMode.JSON_PROTOCOL) >= 0) {
            dataPacket.data = this.JSON_PROTOCOL.writeObject(transmission);
        }
        if (dataPacket.data == null) {
            throw new IllegalArgumentException("a protocol hasn't been specified.");
        }
        String jsonLogging = logger.isTraceEnabled() ? this.getDataAs(dataPacket.data, LogType.STRING) : null;
        this.writeDataPacket(this.writeByteBuffer, dataPacket, this.currentSequenceId);
        if (Arrays.binarySearch((Object[])writeModes, (Object)ChannelWorker.WriteMode.COMPRESSED) >= 0) {
            if (this.compression == null) {
                throw new IllegalArgumentException("compression hasn't been set yet.");
            }
            data = new byte[this.writeByteBuffer.size()];
            for (i = 0; i < data.length; ++i) {
                data[i] = this.writeByteBuffer.get(i);
            }
            this.writeByteBuffer.clear();
            data = this.compression.compress(data);
            dataPacket = new ATransceiver.DataPacket();
            dataPacket.packetType = Enumerations.MessageType.COMPRESSED;
            dataPacket.data = data;
            this.writeDataPacket(this.writeByteBuffer, dataPacket, this.currentSequenceId);
        }
        if (Arrays.binarySearch((Object[])writeModes, (Object)ChannelWorker.WriteMode.ENCRYPTED) >= 0) {
            if (this.cipher == null) {
                throw new IllegalArgumentException("cipher hasn't been set yet.");
            }
            data = new byte[this.writeByteBuffer.size()];
            for (i = 0; i < data.length; ++i) {
                data[i] = this.writeByteBuffer.get(i);
            }
            this.writeByteBuffer.clear();
            data = this.cipher.encrypt(data);
            dataPacket = new ATransceiver.DataPacket();
            dataPacket.packetType = Enumerations.MessageType.ENCRYPTED;
            dataPacket.data = data;
            this.writeDataPacket(this.writeByteBuffer, dataPacket, this.currentSequenceId);
        }
        int writtenBytes = 0;
        while (this.writeByteBuffer.size() > 0) {
            writtenBytes += this.writeData(this.writeByteBuffer);
        }
        if (jsonLogging != null) {
            logger.trace("(" + this.transceiver.getTransceiverID() + ") >> Sending data: " + jsonLogging);
        }
        this.outBytes += (long)writtenBytes;
        if (transmission.getObject() == this.transceiver.getLastObjectToSend()) {
            this.markAsShutdownInProgress();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.trace("execute TERMINATE state as soon as possible");
            this.transceiver.disconnect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write() throws TransceiverException {
        TransmissionContainer container;
        ConcurrentLinkedQueue<TransmissionContainer> concurrentLinkedQueue = this.outgoing;
        synchronized (concurrentLinkedQueue) {
            container = this.outgoing.poll();
        }
        if (container == null) {
            return;
        }
        this.writeContainer(container);
    }

    protected int writeDataPacket(List<Byte> writeByteBuffer, ATransceiver.DataPacket dataPacket, int sequenceId) throws TransceiverException {
        int outBytes;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(dataPacket.packetType.ordinal());
            dout.writeInt(dataPacket.data.length);
            byte[] header = bout.toByteArray();
            byte[] apiRevision = Tools.getBytes(this.getApiRevision());
            byte[] sequence = Tools.getBytes(sequenceId);
            bout = new ByteArrayOutputStream();
            dout = new DataOutputStream(bout);
            dout.writeByte(85);
            dout.write(header);
            dout.write(apiRevision);
            dout.write(sequence);
            dout.write(dataPacket.data);
            byte[] data = bout.toByteArray();
            for (int i = 0; i < data.length; ++i) {
                writeByteBuffer.add(data[i]);
            }
            outBytes = data.length;
        }
        catch (Throwable e) {
            throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "Error while writing data to socket output", e);
        }
        return outBytes;
    }

    protected void readDataPacket(List<Byte> readByteBuffer, ATransceiver.DataPacket dataPacket) throws TransceiverException {
        int length;
        byte[] sync = new byte[1];
        byte[] header = new byte[8];
        byte[] apiRevision = new byte[4];
        byte[] sequence = new byte[4];
        byte[] data = new byte[readByteBuffer.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = readByteBuffer.get(i);
        }
        if ((data = this.filterOutSyncByte(sync, data)) == null) {
            return;
        }
        if ((data = this.filterOut(header, data)) == null) {
            return;
        }
        if ((data = this.filterOut(apiRevision, data)) == null) {
            return;
        }
        if ((data = this.filterOut(sequence, data)) == null) {
            return;
        }
        int start = 0;
        int type = (header[start++] & 0xFF) << 24 | (header[start++] & 0xFF) << 16 | (header[start++] & 0xFF) << 8 | header[start++] & 0xFF;
        if (data.length < (length = (header[start++] & 0xFF) << 24 | (header[start++] & 0xFF) << 16 | (header[start++] & 0xFF) << 8 | header[start++] & 0xFF)) {
            return;
        }
        byte[] tmpData = new byte[length];
        data = this.filterOut(tmpData, data);
        try {
            dataPacket.packetType = Enumerations.MessageType.values()[type];
            dataPacket.data = tmpData;
            dataPacket.sequence = Tools.byteArrayToInt(sequence);
            dataPacket.apiRevision = Tools.byteArrayToInt(apiRevision);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnknownMessageException();
        }
        readByteBuffer.clear();
        for (int i = 0; i < data.length; ++i) {
            readByteBuffer.add(data[i]);
        }
    }

    protected int getApiRevision() {
        if (this.apiRevision == 0) {
            this.apiRevision = this.transceiver.getEnvironment().getSettings().getApiVersions().get(0).getApiRevision();
        }
        return this.apiRevision;
    }

    @Override
    public List<Byte> asByteList(byte[] data) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        if (data == null) {
            return bytes;
        }
        for (int i = 0; i < data.length; ++i) {
            bytes.add(data[i]);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransmissionObject read(ATransceiver.DataPacket dataPacket, boolean wasEncrypted) throws TransceiverException {
        switch (dataPacket.packetType) {
            case COMPRESSED: {
                if (this.compression == null) {
                    throw new UnknownCompressionException();
                }
                byte[] decompressed = this.compression.decompress(dataPacket.data);
                List<Byte> dataInputStream = this.asByteList(decompressed);
                this.readDataPacket(dataInputStream, dataPacket);
                return this.read(dataPacket, wasEncrypted);
            }
            case ENCRYPTED: {
                if (this.cipher == null) {
                    throw new UnknownEncryptionException();
                }
                byte[] decrypted = this.cipher.decrypt(dataPacket.data);
                if (decrypted == null) {
                    throw new CipherException("Unable to decrypt message");
                }
                List<Byte> dataInputStream = this.asByteList(decrypted);
                this.readDataPacket(dataInputStream, dataPacket);
                return this.read(dataPacket, true);
            }
            case PROTOCOL: {
                if (this.cipher != null && !wasEncrypted) {
                    throw new CipherException("Packet not parsed because of missing encryption");
                }
                if (this.protocol == null) {
                    throw new UnknownProtocolException();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("(" + this.transceiver.getTransceiverID() + ") << Reading data: " + this.getDataAs(dataPacket.data, LogType.STRING));
                }
                if (this.isVerifyPacketApiRevision() && dataPacket.apiRevision != this.getApiRevision()) {
                    throw new TransceiverException(Enumerations.ErrorType.UNSUPPORTED_API_VERSION, "Requested ApiRevision is not supported.");
                }
                TransmissionObject transmissionObject = this.protocol.readObject(dataPacket.data);
                transmissionObject.setObject(transmissionObject.getObject());
                if (logger.isWarnEnabled() && transmissionObject.getObject() instanceof NotParsableObject) {
                    logger.warn(transmissionObject.getObject().toString());
                }
                if (this.isVerifyPacketSequence() && transmissionObject.getSequenceID() != this.expectedSequence) {
                    throw new TransceiverException(Enumerations.ErrorType.UNEXPECTED_SEQUENCE, "Sequence received is out of order.");
                }
                AChannelHandler dataInputStream = this;
                synchronized (dataInputStream) {
                    if (this.expectedSequence == Integer.MAX_VALUE) {
                        this.expectedSequence = 0;
                    }
                    ++this.expectedSequence;
                }
                return transmissionObject;
            }
            case ERROR: {
                String errorMessage;
                int errorType = 0;
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(dataPacket.data);
                    DataInputStream dataInputStream = new DataInputStream(bin);
                    errorType = dataInputStream.readInt();
                    errorMessage = Tools.readString(dataInputStream);
                }
                catch (Throwable e) {
                    errorMessage = "Unable to parse error message from client";
                }
                errorMessage = MessageFormat.format("Received error message: type = {0}, message = {1}", errorType, errorMessage);
                logger.error(errorMessage);
                FailResult failResult = new FailResult(errorMessage);
                throw new RemoteException(failResult);
            }
        }
        throw new UnknownMessageException();
    }

    protected byte[] filterOut(byte[] empty, byte[] data) {
        if (empty == null) {
            throw new IllegalArgumentException("byte array to be read into must not be null");
        }
        if (data.length < empty.length) {
            return null;
        }
        int j = 0;
        byte[] rest = new byte[data.length - empty.length];
        for (int i = 0; i < data.length; ++i) {
            if (i < empty.length) {
                empty[i] = data[i];
                continue;
            }
            rest[j] = data[i];
            ++j;
        }
        return rest;
    }

    protected byte[] filterOutSyncByte(byte[] sync, byte[] data) {
        if (sync == null || sync.length != 1) {
            throw new IllegalArgumentException("Sync Byte must be 1 Byte long");
        }
        int index = -1;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 85) continue;
            index = i;
            sync[0] = data[i];
            break;
        }
        if (index == -1) {
            return null;
        }
        int n = data.length - (index + 1);
        byte[] rest = new byte[n];
        int j = 0;
        for (int i = index + 1; i < data.length; ++i) {
            rest[j] = data[i];
            ++j;
        }
        return rest;
    }

    @Override
    public void markAsShutdownInProgress() {
        this.shutdownInProgress = true;
    }

    protected synchronized void sendErrorData(Throwable e, boolean endCommunication) {
        if (this.shutdownInProgress) {
            return;
        }
        this.readByteBuffer.clear();
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            for (Throwable throwable = e.getCause(); throwable != null && errorMessage == null; throwable = throwable.getCause()) {
                errorMessage = throwable.getMessage();
            }
        }
        logger.error(e.getMessage(), e);
        if (e instanceof TransceiverException) {
            TransceiverException ex = (TransceiverException)e;
            errorMessage = errorMessage == null || errorMessage.length() == 0 ? ex.getErrorType().toString() : ex.getErrorType().toString() + ": " + errorMessage;
        }
        int errortype = 0;
        if (e instanceof CipherException) {
            errortype = 1;
        } else if (e instanceof CompressionException) {
            errortype = 2;
        } else if (e instanceof ProtocolException) {
            errortype = 3;
        }
        try {
            ATransceiver.ErrorData errorData = new ATransceiver.ErrorData(errortype, errorMessage);
            ATransceiver.DataPacket errorPacket = new ATransceiver.DataPacket();
            errorPacket.packetType = Enumerations.MessageType.ERROR;
            errorPacket.data = errorData.toByteArray();
            ArrayList<Byte> errorBytes = new ArrayList<Byte>();
            int seqID = Integer.parseInt(this.getSequencePool().getId());
            this.writeDataPacket(errorBytes, errorPacket, seqID);
            this.getSequencePool().freeID(String.valueOf(seqID));
            byte[] allData = new byte[errorBytes.size()];
            for (int i = 0; i < allData.length; ++i) {
                allData[i] = (Byte)errorBytes.get(i);
            }
            int writtenBytes = 0;
            while (errorBytes.size() > 0) {
                writtenBytes += this.writeData(errorBytes);
            }
            this.outBytes += (long)writtenBytes;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            e = t;
            endCommunication = true;
        }
        if (endCommunication) {
            System.err.println(MessageFormat.format("Critical error; shutting down communication {0}", e));
            this.transceiver.exit();
            this.fireNotification(new ConnectionStatus(ConnectionStatus.Status.Rejected, errorMessage));
            this.fireNotification(new ConnectionStatus(ConnectionStatus.Status.Closed, new String[0]));
            this.fireNotification(new CriticalTransportError(e));
        }
    }

    protected void fireNotification(INotification notification) {
        Environment env = null;
        if (this.transceiver != null && (env = this.transceiver.getEnvironment()) != null && env.getApplication() != null) {
            env.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)notification);
        }
    }

    @Override
    public boolean isVerifyPacketSequence() {
        return this.verifyPacketSequence;
    }

    @Override
    public void setVerifyPacketSequence(boolean verifyPacketSequence) {
        this.verifyPacketSequence = verifyPacketSequence;
    }

    @Override
    public boolean isVerifyPacketApiRevision() {
        return this.verifyPacketApiRevision;
    }

    @Override
    public void setVerifyPacketApiRevision(boolean verifyPacketApiRevision) {
        this.verifyPacketApiRevision = verifyPacketApiRevision;
    }

    public int getExpectedSequence() {
        return this.expectedSequence;
    }

    public int getCurrentSequenceId() {
        return this.currentSequenceId;
    }

    protected class TransmissionContainer {
        protected TransmissionObject transmissionObject;
        protected ChannelWorker.WriteMode[] writeModes;

        protected TransmissionContainer() {
        }
    }

    protected static enum Op {
        READ,
        WRITE;

    }

    protected static enum LogType {
        STRING,
        HEX;

    }
}

