/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.protocol.json;

import bsc.api.Enumerations;
import bsc.api.modules.core.model.common.Color;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.model.NotParsableObject;
import bsc.sdk.api.exception.protocol.ProtocolException;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.io.Base64;
import bsc.sdk.io.gson.JsonArray;
import bsc.sdk.io.gson.JsonElement;
import bsc.sdk.io.gson.JsonObject;
import bsc.sdk.io.gson.JsonParser;
import bsc.sdk.io.gson.JsonPrimitive;
import bsc.sdk.io.gson.internal.Primitives;
import bsc.sdk.io.gson.stream.JsonReader;
import bsc.sdk.io.gson.stream.JsonWriter;
import bsc.sdk.tools.Tools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON
implements IProtocol {
    private static Logger logger = LoggerFactory.getLogger(JSON.class);
    public static final String CLASSTYPE = "classType";
    public static final String ENUMTYPE = "enumType";
    public static final String CLASSNAME_MAP = "Map";
    public static final String CLASSNAME_COLLECTION = "List";
    public static final String CLASSNAME_COLOR = "Color";
    public static final String CLASSNAME_ENUM = "Enum";
    public static final String API = "bsc.api";
    public static final String DOTNETAPI = "cli.bsc.sdk";
    public static final String KEYTYPE = "keyType";
    public static final String VALUETYPE = "valueType";
    public static final String DATA = "data";
    public static final String NAME = "name";
    public static final String COLOR = "color";
    private static HashMap<String, String> objectToJSON = new HashMap();
    private static HashMap<String, String> jsonToObject = new HashMap();
    private Base64 base64 = new Base64();

    @Override
    public TransmissionObject readObject(byte[] data) throws ProtocolException {
        String string;
        try {
            string = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProtocolException(e);
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        JsonReader jsonReader = new JsonReader(bufferedReader);
        jsonReader.setLenient(true);
        JsonElement element = new JsonParser().parse(jsonReader);
        if (!element.isJsonObject()) {
            throw new ProtocolException("First JSON element is not an object");
        }
        JsonObject object = element.getAsJsonObject();
        TransmissionObject transmissionObject = new TransmissionObject();
        try {
            element = object.get(CLASSTYPE);
            if (element == null) {
                throw new IOException("Property \"classType\" not set");
            }
            String className = element.getAsString();
            if (!className.equals(TransmissionObject.class.getName())) {
                throw new IOException("The first object must be a TransmissionObject");
            }
            object.remove(CLASSTYPE);
            this.readFields(object, transmissionObject);
        }
        catch (Throwable t) {
            throw new ProtocolException(t);
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (Throwable className) {}
        }
        return transmissionObject;
    }

    private Object readObject(JsonObject jsonObject) throws IOException {
        Object object = null;
        JsonElement element = jsonObject.get(CLASSTYPE);
        if (element == null) {
            throw new IOException("Property \"classType\" not set");
        }
        String className = element.getAsString();
        jsonObject.remove(CLASSTYPE);
        if (className.equals(CLASSNAME_COLLECTION)) {
            object = this.readCollection(jsonObject);
        } else if (className.equals(CLASSNAME_MAP)) {
            object = this.readMap(jsonObject);
        } else if (className.equals(CLASSNAME_COLOR)) {
            object = this.readColor(jsonObject);
        } else if (className.equals(CLASSNAME_ENUM)) {
            object = this.readEnum(jsonObject);
        } else {
            Class<?> newclass;
            if (!className.startsWith(API) && !className.startsWith(DOTNETAPI)) {
                String newClassName = jsonToObject.get(className);
                if (newClassName == null) {
                    throw new IOException("Unsupported object: " + className);
                }
                className = newClassName;
            }
            try {
                newclass = Tools.classForName(className);
            }
            catch (ClassNotFoundException e) {
                newclass = null;
            }
            if (newclass != null) {
                try {
                    Constructor<?> constructor = newclass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    object = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    object = Tools.getInstance(newclass);
                }
                this.readFields(jsonObject, object);
                try {
                    Method method = newclass.getDeclaredMethod("_initAfterJSON", new Class[0]);
                    method.setAccessible(true);
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
            } else {
                object = new NotParsableObject(className);
            }
        }
        return object;
    }

    private Color readColor(JsonObject jsonObject) throws IOException {
        JsonElement element = jsonObject.get(COLOR);
        if (element == null) {
            throw new IOException("Property \"color\" not set");
        }
        int argb = element.getAsInt();
        return new Color(argb);
    }

    private Object readEnum(JsonObject jsonObject) throws IOException {
        Object object;
        JsonElement element = jsonObject.get(ENUMTYPE);
        if (element == null) {
            throw new IOException("Property \"enumType\" not set");
        }
        String type = element.getAsString();
        if (!type.startsWith(API)) {
            throw new IOException("Unsupported enum");
        }
        element = jsonObject.get(NAME);
        if (element == null) {
            throw new IOException("Property \"name\" not set");
        }
        String name = element.getAsString();
        try {
            Class<?> enumClass = Tools.classForName(type);
            Method method = enumClass.getMethod("valueOf", Class.class, String.class);
            object = method.invoke(null, enumClass, name);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        return object;
    }

    private Object readCollection(JsonObject jsonObject) throws IOException {
        Class<?> valueClass;
        JsonElement element = jsonObject.get(VALUETYPE);
        if (element == null) {
            throw new IOException("Property \"valueType\" not set");
        }
        String typeName = element.getAsString();
        jsonObject.remove(VALUETYPE);
        if (!typeName.startsWith(API)) {
            String newTypeName = jsonToObject.get(typeName);
            if (newTypeName == null) {
                throw new IOException("Unsupported object: " + typeName);
            }
            typeName = newTypeName;
        }
        try {
            valueClass = Tools.classForName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        element = jsonObject.get(DATA);
        if (element == null) {
            throw new IOException("Property \"data\" not set");
        }
        ArrayList<Object> collection = new ArrayList<Object>();
        JsonArray jsonArray = element.getAsJsonArray();
        for (JsonElement tmpElement : jsonArray) {
            Object value = this.readValue(tmpElement, valueClass);
            if (value == null) continue;
            collection.add(value);
        }
        return collection;
    }

    private Object readMap(JsonObject jsonObject) throws IOException {
        Class<?> valueClass;
        Class<?> keyClass;
        JsonElement element = jsonObject.get(KEYTYPE);
        if (element == null) {
            throw new IOException("Property \"keyType\" not set");
        }
        String keyType = element.getAsString();
        if (jsonToObject.containsKey(keyType)) {
            keyType = jsonToObject.get(keyType);
        }
        jsonObject.remove(KEYTYPE);
        try {
            keyClass = Tools.classForName(keyType);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        element = jsonObject.get(VALUETYPE);
        if (element == null) {
            throw new IOException("Property \"valueType\" not set");
        }
        String valueType = element.getAsString();
        if (jsonToObject.containsKey(valueType)) {
            valueType = jsonToObject.get(valueType);
        }
        jsonObject.remove(VALUETYPE);
        try {
            valueClass = Tools.classForName(valueType);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        element = jsonObject.get(DATA);
        if (element == null) {
            throw new IOException("Property \"data\" not set");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        JsonArray jsonArray = element.getAsJsonArray();
        for (JsonElement tmpElement : jsonArray) {
            Object value;
            JsonArray tmpArray = null;
            try {
                tmpArray = tmpElement.getAsJsonArray();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Object key = this.readValue(tmpArray.get(0), keyClass);
            if (key == null || (value = this.readValue(tmpArray.get(1), valueClass)) == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private void readFields(JsonObject jsonOjbect, Object object) throws IOException {
        Set<Map.Entry<String, JsonElement>> members = jsonOjbect.entrySet();
        Class<?> clazz = object.getClass();
        for (Map.Entry<String, JsonElement> entry : members) {
            Field field;
            String fieldName = entry.getKey();
            try {
                field = JSON.getInheritedField(clazz, fieldName, false);
            }
            catch (Exception e) {
                continue;
            }
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            Object value = null;
            try {
                value = this.readValue(entry.getValue(), fieldType);
            }
            catch (IOException e) {
                if (object instanceof TransmissionObject && fieldName.equals("object")) {
                    value = new ProtocolException(e);
                }
                throw e;
            }
            try {
                field.set(object, value);
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    private Object readValue(JsonElement jsonElement, Class<?> clazz) throws IOException {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            return this.readObject(jsonObject);
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            return this.readArray(jsonArray, clazz);
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isString() && clazz != null && clazz.isEnum()) {
                Method method;
                String value = jsonPrimitive.getAsString();
                try {
                    method = clazz.getMethod("valueOf", Class.class, String.class);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                try {
                    Object enumObject = method.invoke(null, clazz, value);
                    return enumObject;
                }
                catch (Throwable t) {
                    if (clazz == Enumerations.DeviceType.class) {
                        return Enumerations.DeviceType.UNKNOWN;
                    }
                    throw new IOException(t);
                }
            }
            return this.readPrimitive(jsonPrimitive, clazz);
        }
        return null;
    }

    private LinkedList<Object> readList(JsonArray jsonArray, Class<?> clazz) throws IOException {
        LinkedList<Object> list = new LinkedList<Object>();
        for (JsonElement tmpElement : jsonArray) {
            Class<?> componentType;
            Object value = this.readValue(tmpElement, componentType = clazz.getComponentType());
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private Object readArray(JsonArray jsonArray, Class<?> clazz) throws IOException {
        LinkedList<Object> list = this.readList(jsonArray, clazz);
        Object object = Array.newInstance(clazz.getComponentType(), list.size());
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            Array.set(object, i, list.get(i));
        }
        return object;
    }

    private List<Class<?>> getComponentTypes(Field field) {
        ArrayList genericTypes = new ArrayList();
        Type genericType = field.getGenericType();
        if (genericType instanceof WildcardType) {
            Type[] types;
            for (Type type : types = ((WildcardType)genericType).getUpperBounds()) {
                genericTypes.add((Class)type);
            }
        } else if (genericType instanceof ParameterizedType) {
            Type[] types;
            for (Type type : types = ((ParameterizedType)genericType).getActualTypeArguments()) {
                if (type instanceof Class) {
                    genericTypes.add((Class)type);
                    continue;
                }
                genericTypes.add(Object.class);
            }
        } else {
            genericTypes.add(Object.class);
        }
        return genericTypes;
    }

    private Object readPrimitive(JsonPrimitive jsonPrimitive, Class<?> clazz) throws IOException {
        if (clazz == null) {
            throw new IOException("Given class argument is null");
        }
        if (clazz == Object.class) {
            if (jsonPrimitive.isBoolean()) {
                clazz = Boolean.TYPE;
            } else if (jsonPrimitive.isString()) {
                clazz = String.class;
            }
        }
        if ((clazz = Primitives.wrap(clazz)) == String.class) {
            return jsonPrimitive.getAsString();
        }
        if (Character.class.isAssignableFrom(clazz)) {
            String value = jsonPrimitive.getAsString();
            return Character.valueOf(value.charAt(0));
        }
        if (clazz == Boolean.class) {
            return jsonPrimitive.getAsBoolean();
        }
        return this.readNumber(jsonPrimitive, clazz);
    }

    private Object readNumber(JsonPrimitive jsonPrimitive, Class<?> clazz) throws IOException {
        if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class) {
            Long number = jsonPrimitive.getAsLong();
            if (clazz == Byte.class) {
                return ((Number)number).byteValue();
            }
            if (clazz == Short.class) {
                return ((Number)number).shortValue();
            }
            if (clazz == Integer.class) {
                return ((Number)number).intValue();
            }
            return (long)number;
        }
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Float.class || clazz == Double.class) {
            Double number = jsonPrimitive.getAsDouble();
            if (clazz == Float.class) {
                return Float.valueOf(((Number)number).floatValue());
            }
            return (double)number;
        }
        if (clazz == Object.class || clazz == Number.class) {
            String string = jsonPrimitive.getAsString();
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Short.parseShort(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException3) {
                        try {
                            return Float.valueOf(Float.parseFloat(string));
                        }
                        catch (NumberFormatException numberFormatException4) {
                            try {
                                return Double.parseDouble(string);
                            }
                            catch (NumberFormatException numberFormatException5) {
                                throw new IOException("Unable to parse a number from  " + string);
                            }
                        }
                    }
                }
            }
        }
        if (clazz == byte[].class) {
            String string = jsonPrimitive.getAsString();
            return this.base64.decode(string);
        }
        throw new IOException("Unable to read number for class " + clazz);
    }

    @Override
    public byte[] writeObject(TransmissionObject transmissionObject) throws ProtocolException {
        byte[] data;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        JsonWriter jsonWriter = new JsonWriter(bufferedWriter);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(false);
        jsonWriter.setIndent(" ");
        try {
            this.writeObject(jsonWriter, transmissionObject);
            jsonWriter.flush();
        }
        catch (Throwable t) {
            System.out.println("transmissionObject " + transmissionObject.getClass().toString());
            try {
                jsonWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ProtocolException(t);
        }
        String string = stringWriter.toString();
        try {
            data = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProtocolException(e);
        }
        finally {
            try {
                jsonWriter.close();
            }
            catch (Throwable throwable) {}
        }
        return data;
    }

    protected void writeObject(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        Class<?> clazz = object.getClass();
        String className = clazz.getName();
        if (!this.isAPIClass(className)) {
            String newClassName = objectToJSON.get(className);
            if (newClassName != null) {
                className = newClassName;
            } else {
                Class<?> newClazz = this.getAPIClass(clazz);
                if (newClazz == null) {
                    throw new IOException("Unsupported object: " + className);
                }
                clazz = newClazz;
                className = newClazz.getName();
            }
        }
        jsonWriter.beginObject();
        jsonWriter.name(CLASSTYPE);
        jsonWriter.value(className);
        this.writeFields(jsonWriter, object, clazz);
        jsonWriter.endObject();
    }

    private boolean isAPIClass(String className) {
        return className.startsWith(API) || className.startsWith(DOTNETAPI);
    }

    private Class<?> getAPIClass(Class<?> clazz) {
        Class<?> result = null;
        while (clazz != Object.class) {
            String name = clazz.getName();
            if (this.isAPIClass(name)) {
                result = clazz;
                break;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private void writeFields(JsonWriter jsonWriter, Object object, Class<?> clazz) throws IOException {
        List<Field> fields = JSON.getInheritedFields(clazz, false);
        for (Field field : fields) {
            Class<?> fieldClazz;
            Object fieldValue;
            field.setAccessible(true);
            try {
                fieldValue = field.get(object);
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            if (fieldValue == null) {
                jsonWriter.name(field.getName());
                jsonWriter.nullValue();
                continue;
            }
            if (field.getName().endsWith("k__BackingField") || this.shouldSkipClass(fieldClazz = fieldValue.getClass())) continue;
            jsonWriter.name(field.getName());
            try {
                this.writeValue(jsonWriter, fieldClazz, field, fieldValue);
            }
            catch (Exception e) {
                logger.warn("Unable to write field value for field '" + field.getName() + "'", (Throwable)e);
                jsonWriter.nullValue();
            }
        }
    }

    private void writeValue(JsonWriter jsonWriter, Class<?> valueType, Field field, Object object) throws IOException {
        if (Primitives.isPrimitive(valueType) || Primitives.isWrapperType(valueType) || String.class.isAssignableFrom(valueType) || Number.class.isAssignableFrom(valueType)) {
            this.writePrimitive(jsonWriter, valueType, object);
        } else if (valueType.isArray()) {
            this.writeArray(jsonWriter, valueType, field, object);
        } else if (Collection.class.isAssignableFrom(valueType)) {
            this.writeCollection(jsonWriter, field, (Collection)object);
        } else if (Map.class.isAssignableFrom(valueType)) {
            this.writeMap(jsonWriter, field, (Map)object);
        } else if (valueType.isEnum()) {
            this.writeEnum(jsonWriter, field, (Enum)object);
        } else if (Color.class.isAssignableFrom(valueType)) {
            this.writeColor(jsonWriter, (Color)object);
        } else if (Object.class.isAssignableFrom(valueType)) {
            this.writeObject(jsonWriter, object);
        } else {
            jsonWriter.value(valueType.toString());
        }
    }

    private void writeColor(JsonWriter jsonWriter, Color color) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name(CLASSTYPE);
        jsonWriter.value(CLASSNAME_COLOR);
        jsonWriter.name(COLOR);
        jsonWriter.value(color.getArgp());
        jsonWriter.endObject();
    }

    private void writeEnum(JsonWriter jsonWriter, Field field, Enum<?> value) throws IOException {
        jsonWriter.beginObject();
        String className = value.getClass().getName();
        if (!className.startsWith(API)) {
            throw new IOException("Unsupported enum");
        }
        jsonWriter.name(CLASSTYPE);
        jsonWriter.value(CLASSNAME_ENUM);
        jsonWriter.name(ENUMTYPE);
        jsonWriter.value(className);
        jsonWriter.name(NAME);
        jsonWriter.value(value.name());
        jsonWriter.endObject();
    }

    private void writeMap(JsonWriter jsonWriter, Field field, Map<?, ?> map) throws IOException {
        String newClassName;
        if (field == null) {
            throw new IOException("Maps in collections, maps or arrays are not allowed");
        }
        jsonWriter.beginObject();
        jsonWriter.name(CLASSTYPE);
        jsonWriter.value(CLASSNAME_MAP);
        List<Class<?>> types = this.getComponentTypes(field);
        String className = types.get(0).getName();
        if (!className.startsWith(API)) {
            newClassName = objectToJSON.get(className);
            if (newClassName == null) {
                throw new IOException("Unsupported object: " + className);
            }
            className = newClassName;
        }
        jsonWriter.name(KEYTYPE);
        jsonWriter.value(className);
        className = types.get(1).getName();
        if (!className.startsWith(API)) {
            newClassName = objectToJSON.get(className);
            if (newClassName == null) {
                throw new IOException("Unsupported object: " + className);
            }
            className = newClassName;
        }
        jsonWriter.name(VALUETYPE);
        jsonWriter.value(className);
        jsonWriter.name(DATA);
        jsonWriter.beginArray();
        Object[] keys = map.keySet().toArray();
        Object[] values = map.values().toArray();
        for (int i = 0; i < keys.length; ++i) {
            jsonWriter.beginArray();
            Object key = keys[i];
            Object value = values[i];
            if (key == null) {
                jsonWriter.nullValue();
            } else {
                this.writeValue(jsonWriter, key.getClass(), null, key);
            }
            if (value == null) {
                jsonWriter.nullValue();
            } else {
                this.writeValue(jsonWriter, value.getClass(), null, value);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private void writeCollection(JsonWriter jsonWriter, Field field, Collection<?> collection) throws IOException {
        if (field == null) {
            throw new IOException("Collections in collections, arrays or maps are not allowed");
        }
        jsonWriter.beginObject();
        jsonWriter.name(CLASSTYPE);
        jsonWriter.value(CLASSNAME_COLLECTION);
        List<Class<?>> types = this.getComponentTypes(field);
        String className = types.get(0).getName();
        if (!className.startsWith(API)) {
            String newClassName = objectToJSON.get(className);
            if (newClassName == null) {
                throw new IOException("Unsupported object: " + className);
            }
            className = newClassName;
        }
        jsonWriter.name(VALUETYPE);
        jsonWriter.value(className);
        jsonWriter.name(DATA);
        jsonWriter.beginArray();
        for (Object value : collection) {
            if (value == null) {
                jsonWriter.nullValue();
                continue;
            }
            this.writeValue(jsonWriter, value.getClass(), null, value);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private void writePrimitive(JsonWriter jsonWriter, Class<?> clazz, Object object) throws IOException {
        if ((clazz = Primitives.wrap(clazz)) == String.class) {
            jsonWriter.value((String)object);
        } else if (Character.class.isAssignableFrom(object.getClass())) {
            jsonWriter.value(((Character)object).toString());
        } else if (clazz == Boolean.class) {
            jsonWriter.value((Boolean)object);
        } else {
            this.writeNumber(jsonWriter, clazz, object);
        }
    }

    private void writeNumber(JsonWriter jsonWriter, Class<?> clazz, Object object) throws IOException {
        if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class) {
            Number number = (Number)object;
            jsonWriter.value(number.longValue());
        } else if (clazz == Void.TYPE) {
            jsonWriter.nullValue();
        } else if (clazz == Float.class || clazz == Double.class) {
            Number number = (Number)object;
            jsonWriter.value(number.doubleValue());
        } else if (Number.class.isAssignableFrom(clazz)) {
            jsonWriter.value(((Number)object).doubleValue());
        } else {
            throw new IOException("Unable to write number for class " + clazz);
        }
    }

    private void writeArray(JsonWriter jsonWriter, Class<?> valueType, Field field, Object object) throws IOException {
        if (field == null) {
            throw new IOException("Arrays in collections or maps are not allowed");
        }
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        if (valueType == byte[].class) {
            String encoded = this.base64.encodeAsString((byte[])object);
            jsonWriter.value(encoded);
            return;
        }
        jsonWriter.beginArray();
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(object, i);
            if (!value.getClass().isArray()) {
                field = null;
            }
            this.writeValue(jsonWriter, value.getClass(), field, value);
        }
        jsonWriter.endArray();
    }

    public static List<Field> getInheritedFields(Class<?> type, boolean transientFields) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] tmpFields;
            for (Field field : tmpFields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!transientFields && Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static Field getInheritedField(Class<?> type, String name, boolean transientFields) throws NoSuchFieldException {
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] tmpFields;
            for (Field field : tmpFields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!transientFields && Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || !field.getName().equals(name)) continue;
                return field;
            }
        }
        throw new NoSuchFieldException();
    }

    private boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }

    static {
        objectToJSON.put("java.lang.Byte", "Byte");
        objectToJSON.put("java.lang.Short", "Short");
        objectToJSON.put("java.lang.Character", "Character");
        objectToJSON.put("java.lang.Integer", "Integer");
        objectToJSON.put("java.lang.Long", "Long");
        objectToJSON.put("java.lang.Float", "Float");
        objectToJSON.put("java.lang.Double", "Double");
        objectToJSON.put("java.lang.String", "String");
        objectToJSON.put("java.lang.Object", "Object");
        objectToJSON.put("bsc.api.model.common.Point", "Point");
        objectToJSON.put("bsc.api.model.common.Color", CLASSNAME_COLOR);
        objectToJSON.put("java.lang.StackTraceElement", "StackTraceElement");
        for (Map.Entry<String, String> entry : objectToJSON.entrySet()) {
            if (entry.getKey().startsWith("cli.")) continue;
            jsonToObject.put(entry.getValue(), entry.getKey());
        }
    }
}

