/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.protocol;

import bsc.api.Enumerations;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.api.protocol.json.JSON;

public abstract class ProtocolFactory {
    private static ProtocolFactory defaultFactory = null;

    public static ProtocolFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = ProtocolFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(ProtocolFactory factory) {
        defaultFactory = factory;
    }

    public static ProtocolFactory createDefaultFactory() {
        return new ProtocolFactory(){

            @Override
            public IProtocol createInstance(Enumerations.ProtocolType protocol) {
                if (protocol != null) {
                    switch (protocol) {
                        case JSON: {
                            return new JSON();
                        }
                    }
                    throw new IllegalArgumentException("No protocol for type " + (Object)((Object)protocol));
                }
                return null;
            }
        };
    }

    public static IProtocol newInstance(Enumerations.ProtocolType protocol) {
        return ProtocolFactory.getDefaultFactory().createInstance(protocol);
    }

    public abstract IProtocol createInstance(Enumerations.ProtocolType var1);
}

