/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager.cache;

import bsc.api.IIdentifiableApiObject;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.objects.manager.cache.IDeviceCacheProcessor;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public interface IUserObjectCache {
    public void refreshObject(UserCredentialIdentifier var1, ObjectIdentifier var2);

    public void refreshObject(ObjectIdentifier var1);

    public void removeObject(ObjectIdentifier var1);

    public void removeObjectForUser(UserCredentialIdentifier var1, ObjectIdentifier var2);

    public void clearUserCache(UserCredentialIdentifier var1);

    public void shutdown();

    public void init(Environment var1);

    public Environment getEnvironment();

    public boolean isRebuildInProgress();

    public int getCurrentWorkerCount();

    public void waitForCacheRebuild(UserCredentialIdentifier var1);

    public void waitForCacheRebuild(ObjectIdentifier var1);

    public void waitForCacheRebuild(UserCredentialIdentifier var1, ObjectIdentifier var2);

    public IIdentifiableApiObject getObjectFromCache(UserCredentialIdentifier var1, ObjectIdentifier var2);

    public Map<String, IIdentifiableApiObject> getUserObjectCache(UserCredentialIdentifier var1);

    public EnumSet<Permission> getUserPermissionFromCache(UserCredentialIdentifier var1, ObjectIdentifier var2);

    public Map<String, EnumSet<Permission>> getUserPermissionCache(UserCredentialIdentifier var1);

    public Map<String, IIdentifiableApiObject> getUserObjectCacheByType(UserCredentialIdentifier var1, EnumSet<ObjectIdentifier.OBJECT_TYPE> var2);

    public Set<IIdentifiableApiObject> getObjectFromCache(UserCredentialIdentifier var1, ObjectIdentifier ... var2);

    public void registerDeviceCacheProcessor(IDeviceCacheProcessor var1);

    public void unregisterDeviceCacheProcessor(IDeviceCacheProcessor var1);
}

