/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager;

import bsc.api.ApiObjectIdentifier;
import bsc.api.basic.model.ISensor;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.IObjectManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class SensorIdentifier
extends DeviceIdentifier {
    public static int SENSOR_ID_PART = 2;
    private final String sensorID = this.getPathPart(SENSOR_ID_PART);

    public SensorIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getSensorID() {
        return this.sensorID;
    }

    public static URI generateURI(String deviceID, String sensorID, String applicationID, String host) {
        return ApiObjectIdentifier.getSensorURI(deviceID, sensorID, applicationID, host);
    }

    public DeviceIdentifier getDeviceIdentifier() {
        IObjectManager objectManager = this.getEnvironment().getObjectManager();
        DeviceIdentifier identifier = (DeviceIdentifier)objectManager.getIdentifierInstance(SensorIdentifier.generateURI(this.getDeviceID(), this.getEnvironment()));
        return identifier;
    }

    public static URI generateURI(String deviceID, String sensorID, Environment enviromentSettings) {
        return SensorIdentifier.generateURI(deviceID, sensorID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static SensorIdentifier createIdentifierInstance(String deviceID, String sensorID, Environment environment) throws URISyntaxException {
        return new SensorIdentifier(SensorIdentifier.generateURI(deviceID, sensorID, environment));
    }

    public static SensorIdentifier createIdentifierInstance(ISensor sensor, Environment environment) throws URISyntaxException {
        return new SensorIdentifier(SensorIdentifier.generateURI(Objects.requireNonNull(sensor, "sensor must not be null!").getDeviceID(), sensor.getSensorID(), environment));
    }
}

