/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.weatherstation;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.GeoDirectionSensor;
import bsc.api.modules.core.model.sensor.GeoPositionSensor;
import bsc.api.modules.core.model.sensor.SunIntensitySensor;
import bsc.api.modules.core.model.sensor.state.DayNightSensor;
import bsc.api.modules.core.model.sensor.state.detection.RainDetection;
import bsc.api.modules.core.model.sensor.value.BrightnessSensor;
import bsc.api.modules.core.model.sensor.value.DateTime;
import bsc.api.modules.core.model.sensor.value.WindSpeedSensor;
import bsc.api.modules.core.model.sensor.value.temp.InnerTemp;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.weatherstation.configuration.WeatherstationElsnerConfiguration;
import bsc.sdk.api.objects.device.type.weatherstation.configuration.WeatherstationEltakoConfiguration;

public class WeatherstationFactory
extends DeviceFactory {
    private static WeatherstationFactory defaultFactory = null;

    public static WeatherstationFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = WeatherstationFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(WeatherstationFactory factory) {
        defaultFactory = factory;
    }

    public static WeatherstationFactory createDefaultFactory() {
        return new WeatherstationFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return WeatherstationFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case WeatherstationEltako: {
                return this.createWeatherstationEltako((WeatherstationEltakoConfiguration)deviceConfiguration);
            }
            case WeatherstationElsner: {
                return this.createWeatherstationElsner((WeatherstationElsnerConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createWeatherstationElsner(WeatherstationElsnerConfiguration deviceConfiguration) {
        Device device = this.createWeatherstationEltako(deviceConfiguration);
        DateTime time = new DateTime(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.DateTime, deviceConfiguration.getDateTimeSensorId(), deviceConfiguration.getDateTimeValueSettings(), time);
        device.addSensor(time);
        GeoDirectionSensor direction = new GeoDirectionSensor(deviceConfiguration.getDeviceID());
        this.fillSensor(Enumerations.SensorName.GeoDirection, deviceConfiguration.getGeoDirectionSensorId(), direction);
        direction.setAzimut(deviceConfiguration.getGeoDirectionValueSettings().get((Object)WeatherstationElsnerConfiguration.DIRECTION.AZIMUT).getCurrentValue());
        direction.setElevation(deviceConfiguration.getGeoDirectionValueSettings().get((Object)WeatherstationElsnerConfiguration.DIRECTION.ELEVATION).getCurrentValue());
        device.addSensor(direction);
        GeoPositionSensor position = new GeoPositionSensor(deviceConfiguration.getDeviceID());
        this.fillSensor(Enumerations.SensorName.GeoPosition, deviceConfiguration.getGeoPositionSensorId(), position);
        position.setLatitude(deviceConfiguration.getGeoPositionValueSettings().get((Object)WeatherstationElsnerConfiguration.POSITION.LATITUDE).getCurrentValue());
        position.setLongitude(deviceConfiguration.getGeoPositionValueSettings().get((Object)WeatherstationElsnerConfiguration.POSITION.LONGITUDE).getCurrentValue());
        device.addSensor(position);
        return device;
    }

    protected Device createWeatherstationEltako(WeatherstationEltakoConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        InnerTemp temp = new InnerTemp(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Temperature, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), temp);
        device.addSensor(temp);
        BrightnessSensor brightness = new BrightnessSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Brightness, deviceConfiguration.getBrightnessSensorId(), deviceConfiguration.getBrightnessValueSettings(), brightness);
        device.addSensor(brightness);
        WindSpeedSensor wind = new WindSpeedSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.WindSpeed, deviceConfiguration.getWindSpeedSensorId(), deviceConfiguration.getWindSpeedValueSettings(), wind);
        device.addSensor(wind);
        DayNightSensor dayNight = new DayNightSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.DayNight, deviceConfiguration.getDayNightSensorId(), deviceConfiguration.getDayNightCurrentState(), dayNight);
        device.addSensor(dayNight);
        RainDetection rain = new RainDetection(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.RainDetection, deviceConfiguration.getRainSensorId(), deviceConfiguration.getRainCurrentState(), rain);
        device.addSensor(rain);
        SunIntensitySensor sun = new SunIntensitySensor(deviceConfiguration.getDeviceID());
        this.fillSensor(Enumerations.SensorName.SunIntensity, deviceConfiguration.getSunIntensitySensorId(), sun);
        sun.setHemisphere(deviceConfiguration.getSunIntensityValueSettingsHemisphere());
        sun.setIntensityEast(deviceConfiguration.getSunIntensityValueSettings().get((Object)WeatherstationEltakoConfiguration.DIRECTION.EAST).getCurrentValue());
        sun.setIntensitySouth(deviceConfiguration.getSunIntensityValueSettings().get((Object)WeatherstationEltakoConfiguration.DIRECTION.SOUTH).getCurrentValue());
        sun.setIntensityWest(deviceConfiguration.getSunIntensityValueSettings().get((Object)WeatherstationEltakoConfiguration.DIRECTION.WEST).getCurrentValue());
        sun.setMeasuringUnit(deviceConfiguration.getSunIntensityValueSettings().get((Object)WeatherstationEltakoConfiguration.DIRECTION.WEST).getMeasuringUnit());
        device.addSensor(sun);
        return device;
    }
}

