/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.timer.configuration;

import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.WeekdaySensor;
import bsc.api.modules.core.model.sensor.value.DateTime;
import bsc.api.modules.timer.model.Timer;
import bsc.api.modules.timer.model.TimerControl;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.timer.configuration.TimerConfiguration;
import bsc.sdk.api.objects.device.type.timer.configuration.TimerControlConfiguration;
import java.util.ArrayList;
import java.util.List;

public class TimerFactory
extends DeviceFactory {
    private static TimerFactory defaultFactory = null;

    public static TimerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = TimerFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(TimerFactory factory) {
        defaultFactory = factory;
    }

    public static TimerFactory createDefaultFactory() {
        return new TimerFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return TimerFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case Timer: {
                return this.createTimer((TimerConfiguration)deviceConfiguration);
            }
            case TimerControl: {
                return this.createTimerControl((TimerControlConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Timer createTimer(TimerConfiguration deviceConfiguration) {
        Timer timer = new Timer(deviceConfiguration.getDeviceID());
        this.fillDevice(deviceConfiguration, timer);
        timer.setEnabled(deviceConfiguration.isEnabled());
        timer.setMode(deviceConfiguration.getMode());
        timer.setOffset(deviceConfiguration.getOffset());
        timer.setPeriod(deviceConfiguration.getPeriod());
        timer.setSelectedDays(deviceConfiguration.getSelectedDays());
        timer.setSunrise(deviceConfiguration.getSunriseTimestamp());
        timer.setSunset(deviceConfiguration.getSunsetTimestamp());
        timer.setType(deviceConfiguration.getType());
        timer.setTime(deviceConfiguration.getTimestamp());
        return timer;
    }

    protected TimerControl createTimerControl(TimerControlConfiguration deviceConfiguration) {
        TimerControl control = new TimerControl(deviceConfiguration.getDeviceID());
        this.fillDevice(deviceConfiguration, control);
        control.setClockMode(deviceConfiguration.getClockMode());
        control.setTimeMode(this.createTimeMode(deviceConfiguration));
        control.setDateMode(this.createDateMode(deviceConfiguration));
        control.setProgTime1(this.createProgrammableValues(1, deviceConfiguration));
        control.setProgTime2(this.createProgrammableValues(2, deviceConfiguration));
        control.setProgTime3(this.createProgrammableValues(3, deviceConfiguration));
        control.setProgTime4(this.createProgrammableValues(4, deviceConfiguration));
        control.setProgTime5(this.createProgrammableValues(5, deviceConfiguration));
        control.setProgTime6(this.createProgrammableValues(6, deviceConfiguration));
        control.setProgTime7(this.createProgrammableValues(7, deviceConfiguration));
        control.setProgTime8(this.createProgrammableValues(8, deviceConfiguration));
        control.setProgTime9(this.createProgrammableValues(9, deviceConfiguration));
        control.setIntervalMode(this.createIntervalMode(deviceConfiguration));
        control.setPumpOverrunMode(this.createOverrunMode(deviceConfiguration));
        return control;
    }

    private List<DateTime> createTimeMode(TimerControlConfiguration deviceConfiguration) {
        DateTime hourSensor = new DateTime(deviceConfiguration.getDeviceID());
        hourSensor.setSensorID(deviceConfiguration.getHourSensorId());
        hourSensor.setValue(deviceConfiguration.getHourValue().doubleValue());
        hourSensor.setMinValue(0.0);
        hourSensor.setMaxValue(23.0);
        hourSensor.setStepping(1.0);
        DateTime minutesSensor = new DateTime(deviceConfiguration.getDeviceID());
        minutesSensor.setSensorID(deviceConfiguration.getMinuteSensorId());
        minutesSensor.setValue(deviceConfiguration.getMinuteValue().doubleValue());
        minutesSensor.setMinValue(0.0);
        minutesSensor.setMaxValue(59.0);
        minutesSensor.setStepping(1.0);
        ArrayList<DateTime> timeMode = new ArrayList<DateTime>();
        timeMode.add(hourSensor);
        timeMode.add(minutesSensor);
        return timeMode;
    }

    private List<DateTime> createDateMode(TimerControlConfiguration deviceConfiguration) {
        DateTime daySensor = new DateTime(deviceConfiguration.getDeviceID());
        daySensor.setSensorID(deviceConfiguration.getDaySensorId());
        daySensor.setValue(deviceConfiguration.getDayValue().doubleValue());
        daySensor.setMinValue(1.0);
        daySensor.setMaxValue(31.0);
        daySensor.setStepping(1.0);
        DateTime monthSensor = new DateTime(deviceConfiguration.getDeviceID());
        monthSensor.setSensorID(deviceConfiguration.getMonthSensorId());
        monthSensor.setValue(deviceConfiguration.getMonthValue().doubleValue());
        monthSensor.setMinValue(1.0);
        monthSensor.setMaxValue(12.0);
        monthSensor.setStepping(1.0);
        DateTime yearSensor = new DateTime(deviceConfiguration.getDeviceID());
        yearSensor.setSensorID(deviceConfiguration.getYearSensorId());
        yearSensor.setValue(2000.0 + deviceConfiguration.getYearValue().doubleValue());
        yearSensor.setMinValue(2000.0);
        yearSensor.setMaxValue(2099.0);
        yearSensor.setStepping(1.0);
        ArrayList<DateTime> dateMode = new ArrayList<DateTime>();
        dateMode.add(daySensor);
        dateMode.add(monthSensor);
        dateMode.add(yearSensor);
        return dateMode;
    }

    private List<ISensor> createIntervalMode(TimerControlConfiguration deviceConfiguration) {
        DateTime hourStartSensor = new DateTime(deviceConfiguration.getDeviceID());
        hourStartSensor.setSensorID(deviceConfiguration.getHourStartSensorId());
        hourStartSensor.setValue(deviceConfiguration.getHourStartValue().doubleValue());
        hourStartSensor.setMinValue(0.0);
        hourStartSensor.setMaxValue(23.0);
        hourStartSensor.setStepping(1.0);
        DateTime minuteStartSensor = new DateTime(deviceConfiguration.getDeviceID());
        minuteStartSensor.setSensorID(deviceConfiguration.getMinuteStartSensorId());
        minuteStartSensor.setValue(deviceConfiguration.getMinuteStartValue().doubleValue());
        minuteStartSensor.setMinValue(0.0);
        minuteStartSensor.setMaxValue(59.0);
        minuteStartSensor.setStepping(1.0);
        WeekdaySensor weekDayStartSensor = new WeekdaySensor(deviceConfiguration.getDeviceID());
        weekDayStartSensor.setSensorID(deviceConfiguration.getWeekdayStartSensorId());
        this.configureWeekdaySensor(deviceConfiguration.getWeekdayStartValue(), weekDayStartSensor);
        DateTime durationMinutes = new DateTime(deviceConfiguration.getDeviceID());
        durationMinutes.setSensorID(deviceConfiguration.getDurationSensorId());
        durationMinutes.setValue(deviceConfiguration.getDurationValue().doubleValue());
        durationMinutes.setMinValue(0.0);
        durationMinutes.setMaxValue(15.0);
        durationMinutes.setStepping(1.0);
        ArrayList<ISensor> intervalMode = new ArrayList<ISensor>();
        intervalMode.add(hourStartSensor);
        intervalMode.add(minuteStartSensor);
        intervalMode.add(weekDayStartSensor);
        intervalMode.add(durationMinutes);
        return intervalMode;
    }

    private List<DateTime> createOverrunMode(TimerControlConfiguration deviceConfiguration) {
        DateTime overrunMinutes = new DateTime(deviceConfiguration.getDeviceID());
        overrunMinutes.setSensorID(deviceConfiguration.getOverrunSensorId());
        overrunMinutes.setValue(deviceConfiguration.getOverrunValue().doubleValue());
        overrunMinutes.setMinValue(0.0);
        overrunMinutes.setMaxValue(15.0);
        overrunMinutes.setStepping(1.0);
        ArrayList<DateTime> pumpOverrunMode = new ArrayList<DateTime>();
        pumpOverrunMode.add(overrunMinutes);
        return pumpOverrunMode;
    }

    private List<ISensor> createProgrammableValues(int programmableChannelNo, TimerControlConfiguration deviceConfiguration) {
        int sensorData;
        String sensorID;
        ArrayList<ISensor> programmableChannel = new ArrayList<ISensor>();
        String deviceID = deviceConfiguration.getDeviceID();
        int SENSOR_ID = 0;
        int SENSOR_DATA = 1;
        int[] channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.CHANNELS_1_2);
        if (channelData != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            EnabledSensor channel1 = new EnabledSensor(deviceID);
            EnabledSensor channel2 = new EnabledSensor(deviceID);
            channel1.setSensorID(sensorID);
            channel2.setSensorID(sensorID + "_2");
            this.configureEnabledSensors(sensorData, channel1, channel2);
            programmableChannel.add(channel1);
            programmableChannel.add(channel2);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.HOUR_START)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            DateTime hourStartSensor = new DateTime(deviceID);
            hourStartSensor.setSensorID(sensorID);
            hourStartSensor.setValue(sensorData);
            hourStartSensor.setMinValue(0.0);
            hourStartSensor.setMaxValue(23.0);
            hourStartSensor.setStepping(1.0);
            programmableChannel.add(hourStartSensor);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.MINUTE_START)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            DateTime minuteStartSensor = new DateTime(deviceID);
            minuteStartSensor.setSensorID(sensorID);
            minuteStartSensor.setValue(sensorData);
            minuteStartSensor.setMinValue(0.0);
            minuteStartSensor.setMaxValue(59.0);
            minuteStartSensor.setStepping(1.0);
            programmableChannel.add(minuteStartSensor);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.START_DAY_OF_WEEK)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            WeekdaySensor weekDayStart = new WeekdaySensor(deviceID);
            weekDayStart.setSensorID(sensorID);
            this.configureWeekdaySensor(sensorData, weekDayStart);
            programmableChannel.add(weekDayStart);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.HOUR_STOP)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            DateTime hourStopSensor = new DateTime(deviceID);
            hourStopSensor.setSensorID(sensorID);
            hourStopSensor.setValue(sensorData);
            hourStopSensor.setMinValue(0.0);
            hourStopSensor.setMaxValue(23.0);
            hourStopSensor.setStepping(1.0);
            programmableChannel.add(hourStopSensor);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.MINUTE_STOP)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            DateTime minuteStopSensor = new DateTime(deviceID);
            minuteStopSensor.setSensorID(sensorID);
            minuteStopSensor.setValue(sensorData);
            minuteStopSensor.setMinValue(0.0);
            minuteStopSensor.setMaxValue(59.0);
            minuteStopSensor.setStepping(1.0);
            programmableChannel.add(minuteStopSensor);
        }
        if ((channelData = deviceConfiguration.getProgrammableChannelValue(programmableChannelNo, TimerControlConfiguration.ProgrammableItem.STOP_DAY_OF_WEEK)) != null && channelData.length == 2) {
            sensorID = String.valueOf(channelData[SENSOR_ID]);
            sensorData = channelData[SENSOR_DATA];
            WeekdaySensor weekDayStop = new WeekdaySensor(deviceID);
            weekDayStop.setSensorID(sensorID);
            this.configureWeekdaySensor(sensorData, weekDayStop);
            programmableChannel.add(weekDayStop);
        }
        return programmableChannel;
    }

    private void configureEnabledSensors(Integer channelState, EnabledSensor channel1, EnabledSensor channel2) {
        switch (channelState) {
            case 0: {
                channel1.setState(EnabledSensor.State.DISABLED);
                channel2.setState(EnabledSensor.State.DISABLED);
                break;
            }
            case 1: {
                channel1.setState(EnabledSensor.State.ENABLED);
                channel2.setState(EnabledSensor.State.DISABLED);
                break;
            }
            case 2: {
                channel1.setState(EnabledSensor.State.DISABLED);
                channel2.setState(EnabledSensor.State.ENABLED);
                break;
            }
            case 3: {
                channel1.setState(EnabledSensor.State.ENABLED);
                channel2.setState(EnabledSensor.State.ENABLED);
                break;
            }
        }
    }

    private void configureWeekdaySensor(Integer weekday, WeekdaySensor weekDaySensor) {
        switch (weekday) {
            default: {
                weekDaySensor.setState(WeekdaySensor.State.MONDAY);
                break;
            }
            case 2: {
                weekDaySensor.setState(WeekdaySensor.State.TUESDAY);
                break;
            }
            case 3: {
                weekDaySensor.setState(WeekdaySensor.State.WEDNESDAY);
                break;
            }
            case 4: {
                weekDaySensor.setState(WeekdaySensor.State.THURSDAY);
                break;
            }
            case 5: {
                weekDaySensor.setState(WeekdaySensor.State.FRIDAY);
                break;
            }
            case 6: {
                weekDaySensor.setState(WeekdaySensor.State.SATURDAY);
                break;
            }
            case 7: {
                weekDaySensor.setState(WeekdaySensor.State.SUNDAY);
            }
        }
    }
}

