/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.temperature;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.ACNFSlideSwitch;
import bsc.api.modules.core.model.sensor.state.ButtonSensor;
import bsc.api.modules.core.model.sensor.state.DayNightSensor;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.FanSpeedStateSensor;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.WindowSensor;
import bsc.api.modules.core.model.sensor.state.check.BatteryCheck;
import bsc.api.modules.core.model.sensor.state.detection.EmptyDetection;
import bsc.api.modules.core.model.sensor.state.detection.ErrorDetection;
import bsc.api.modules.core.model.sensor.state.detection.HeatDetection;
import bsc.api.modules.core.model.sensor.state.detection.HeatingDetection;
import bsc.api.modules.core.model.sensor.state.detection.LeckageDetection;
import bsc.api.modules.core.model.sensor.state.detection.ManometerSetpointDetection;
import bsc.api.modules.core.model.sensor.state.detection.MinDetection;
import bsc.api.modules.core.model.sensor.state.detection.MoistureDetection;
import bsc.api.modules.core.model.sensor.state.detection.MotionDetection;
import bsc.api.modules.core.model.sensor.state.detection.OccupancyDetection;
import bsc.api.modules.core.model.sensor.state.detection.PresenceDetection;
import bsc.api.modules.core.model.sensor.state.detection.RainDetection;
import bsc.api.modules.core.model.sensor.state.detection.SmokeDetection;
import bsc.api.modules.core.model.sensor.state.detection.VoltageDetection;
import bsc.api.modules.core.model.sensor.state.detection.WaterDetection;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.state.on.RelayOn;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.api.modules.core.model.sensor.value.HumintySensor;
import bsc.api.modules.core.model.sensor.value.SetPointSensor;
import bsc.api.modules.core.model.sensor.value.TempSensor;
import bsc.api.modules.core.model.sensor.value.ValueSensor;
import bsc.api.modules.core.model.sensor.value.gas.CO2Sensor;
import bsc.api.modules.core.model.sensor.value.temp.InnerTemp;
import bsc.api.modules.core.model.sensor.value.temp.OutherTemp;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.GenericTemperatureConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempButtonConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempCO2Configuration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempCO2HumidityConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempDetectionConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempHumidityConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempHumidityHSetPointConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempHumidityVoltageConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointButtonConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointButtonFanConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointDayNightConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointDetectionConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointDetectionOnConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointFanConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointFanDetectionConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointHumidityButtonConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointHumidityConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointPriorityConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointPriorityPercentageConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointSlideSwitchConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointVoltageConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointWindowBatteryConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetPointWindowConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetpointRelayConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetpointRelayPriorityConfiguration;
import bsc.sdk.api.objects.device.type.temperature.configuration.TempSetpointRelayPriorityErrorDeviceConfiguration;

public class TemperatureFactory
extends DeviceFactory {
    private static TemperatureFactory defaultFactory = null;

    public static TemperatureFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = TemperatureFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(TemperatureFactory factory) {
        defaultFactory = factory;
    }

    public static TemperatureFactory createDefaultFactory() {
        return new TemperatureFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return TemperatureFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case TempButton: {
                return this.createTempButton((TempButtonConfiguration)deviceConfiguration);
            }
            case TempCO2: {
                return this.createTempCO2((TempCO2Configuration)deviceConfiguration);
            }
            case TempCO2Humidity: {
                return this.createTempCO2Humidity((TempCO2HumidityConfiguration)deviceConfiguration);
            }
            case TempDetection: {
                return this.createTempDetection((TempDetectionConfiguration)deviceConfiguration);
            }
            case TempHumidity: {
                return this.createTempHumidity((TempHumidityConfiguration)deviceConfiguration);
            }
            case TempHumidityHSetPoint: {
                return this.createTempHumidityHSetPoint((TempHumidityHSetPointConfiguration)deviceConfiguration);
            }
            case TempHumidityVoltage: {
                return this.createTempHumidityVoltage((TempHumidityVoltageConfiguration)deviceConfiguration);
            }
            case TempSetPoint: 
            case TempSetPointRelayAndOrPriority: {
                return this.createTempSetPoint((TempSetPointConfiguration)deviceConfiguration);
            }
            case TempSetPointButton: {
                return this.createTempSetPointButton((TempSetPointButtonConfiguration)deviceConfiguration);
            }
            case TempSetPointButtonFan: {
                return this.createTempSetPointButtonFan((TempSetPointButtonFanConfiguration)deviceConfiguration);
            }
            case TempSetPointFan: {
                return this.createTempSetPointFan((TempSetPointFanConfiguration)deviceConfiguration);
            }
            case TempSetPointFanDetection: {
                return this.createTempSetPointFanDetection((TempSetPointFanDetectionConfiguration)deviceConfiguration);
            }
            case TempSetPointPriority: {
                return this.createTempSetPointPriority((TempSetPointPriorityConfiguration)deviceConfiguration);
            }
            case TempSetPointPriorityPercentage: {
                return this.createTempSetPointPriorityPercentage((TempSetPointPriorityPercentageConfiguration)deviceConfiguration);
            }
            case TempSetPointVoltage: {
                return this.createTempSetPointVoltage((TempSetPointVoltageConfiguration)deviceConfiguration);
            }
            case TempSetPointDayNight: {
                return this.createTempSetPointDayNight((TempSetPointDayNightConfiguration)deviceConfiguration);
            }
            case TempSetPointDetection: {
                return this.createTempSetPointDetection((TempSetPointDetectionConfiguration)deviceConfiguration);
            }
            case TempSetPointDetectionOn: {
                return this.createTempSetPointOnDetection((TempSetPointDetectionOnConfiguration)deviceConfiguration);
            }
            case TempSetPointHumidity: {
                return this.createTempSetPointHumidity((TempSetPointHumidityConfiguration)deviceConfiguration);
            }
            case TempSetPointHumidityButton: {
                return this.createTempSetPointHumidityButton((TempSetPointHumidityButtonConfiguration)deviceConfiguration);
            }
            case TempSetPointSlideSwitch: {
                return this.createTempSetPointSlideSwitch((TempSetPointSlideSwitchConfiguration)deviceConfiguration);
            }
            case TempSetPointWindow: {
                return this.createTempSetPointWindow((TempSetPointWindowConfiguration)deviceConfiguration);
            }
            case TempSetPointWindowBattery: {
                return this.createTempSetPointWindowBattery((TempSetPointWindowBatteryConfiguration)deviceConfiguration);
            }
            case GenericTemperature: {
                return this.createGenericTemperature((GenericTemperatureConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private Device createTempSetPointSlideSwitch(TempSetPointSlideSwitchConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        ACNFSlideSwitch sensor = new ACNFSlideSwitch(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getSlideSwitchSensorType(), deviceConfiguration.getSlideSwitchSensorId(), deviceConfiguration.getSlideSwitchState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempSetPointHumidityButton(TempSetPointHumidityButtonConfiguration deviceConfiguration) {
        Device device = this.createTempSetPointHumidity(deviceConfiguration);
        ButtonSensor sensor = new ButtonSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getButtonSensorType().getParent(), deviceConfiguration.getButtonSensorId(), deviceConfiguration.getButtonState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempButton(TempButtonConfiguration deviceConfiguration) {
        Device device = this.createGenericTemperature(deviceConfiguration);
        ButtonSensor sensor = new ButtonSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getButtonSensorType().getParent(), deviceConfiguration.getButtonSensorId(), deviceConfiguration.getButtonState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempSetPointFan(TempSetPointFanConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        FanSpeedStateSensor sensor = new FanSpeedStateSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getFanSensorType().getParent(), deviceConfiguration.getFanSensorId(), deviceConfiguration.getFanState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempSetPointFanDetection(TempSetPointFanDetectionConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        FanSpeedStateSensor fanSensor = new FanSpeedStateSensor(deviceConfiguration.getDeviceID());
        DetectionSensor detectionSensor = new DetectionSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getFanSensorType().getParent(), deviceConfiguration.getFanSensorId(), deviceConfiguration.getFanState(), fanSensor);
        device.addSensor(fanSensor);
        this.fillStateSensor(deviceConfiguration.getDetectionSensorType().getParent(), deviceConfiguration.getDetectionSensorId(), deviceConfiguration.getDetectionCurrentState(), detectionSensor);
        device.addSensor(detectionSensor);
        return device;
    }

    private Device createTempSetPointButton(TempSetPointButtonConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        ButtonSensor sensor = new ButtonSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getButtonSensorType().getParent(), deviceConfiguration.getButtonSensorId(), deviceConfiguration.getButtonState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempSetPointButtonFan(TempSetPointButtonFanConfiguration deviceConfiguration) {
        Device device = this.createTempSetPointButton(deviceConfiguration);
        FanSpeedStateSensor sensor = new FanSpeedStateSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getFanSensorType().getParent(), deviceConfiguration.getFanSensorId(), deviceConfiguration.getFanState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericTemperature(GenericTemperatureConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempSetPointWindowBattery(TempSetPointWindowBatteryConfiguration deviceConfiguration) {
        Device device = this.createTempSetPointWindow(deviceConfiguration);
        BatteryCheck sensor = new BatteryCheck(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempHumidityHSetPoint(TempHumidityHSetPointConfiguration deviceConfiguration) {
        Device device = this.createTempHumidity(deviceConfiguration);
        SetPointSensor sensor = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.gethSetPointSensorId(), deviceConfiguration.gethSetPointValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempHumidityVoltage(TempHumidityVoltageConfiguration deviceConfiguration) {
        Device device = this.createTempHumidity(deviceConfiguration);
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getVoltageValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempSetPointWindow(TempSetPointWindowConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        WindowSensor sensor = new WindowSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Window, deviceConfiguration.getWindowSensorId(), deviceConfiguration.getWindowCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempSetPointHumidity(TempSetPointHumidityConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        HumintySensor sensor = new HumintySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Humidity, deviceConfiguration.getHumiditySensorId(), deviceConfiguration.getHumidityValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempSetPointDetection(TempSetPointDetectionConfiguration deviceConfiguration) {
        DetectionSensor sensor;
        Device device = this.createTempSetPoint(deviceConfiguration);
        switch (deviceConfiguration.getDetectionSensorType()) {
            case EMPTY: {
                sensor = new EmptyDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case HEATING: {
                sensor = new HeatingDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case LECKAGE: {
                sensor = new LeckageDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MANOMETER_SETPOINT: {
                sensor = new ManometerSetpointDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MIN: {
                sensor = new MinDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MOISTURE: {
                sensor = new MoistureDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MOTION: {
                sensor = new MotionDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case OCCUPANCY: {
                sensor = new OccupancyDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case PRESENCE: {
                sensor = new PresenceDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case RAIN: {
                sensor = new RainDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case VOLTAGE: {
                sensor = new VoltageDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case WATER: {
                sensor = new WaterDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case SMOKE: {
                sensor = new SmokeDetection(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new DetectionSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getDetectionSensorType().getParent(), deviceConfiguration.getDetectionSensorId(), deviceConfiguration.getDetectionCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private Device createTempSetPointOnDetection(TempSetPointDetectionOnConfiguration deviceConfiguration) {
        Device device = this.createTempSetPointDetection(deviceConfiguration);
        OnSensor onSensor = new OnSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getOnSensorType().getParent(), deviceConfiguration.getOnSensorId(), deviceConfiguration.getOnState(), onSensor);
        device.addSensor(onSensor);
        return device;
    }

    protected Device createTempSetPointDayNight(TempSetPointDayNightConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        DayNightSensor sensor = new DayNightSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.DayNight, deviceConfiguration.getDayNightSensorId(), deviceConfiguration.getDayNightCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempSetPoint(TempSetPointConfiguration deviceConfiguration) {
        Device device = this.createGenericTemperature(deviceConfiguration);
        SetPointSensor sensor = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), sensor);
        device.addSensor(sensor);
        if (deviceConfiguration instanceof TempSetpointRelayConfiguration) {
            TempSetpointRelayConfiguration relayConfig = (TempSetpointRelayConfiguration)deviceConfiguration;
            RelayOn relayOnSensor = new RelayOn(deviceConfiguration.getDeviceID());
            relayOnSensor.setName(Enumerations.SensorName.Relay.getSensorName());
            relayOnSensor.setSensorID(relayConfig.getRelaySensorId());
            relayOnSensor.setState(relayConfig.getRelayStateSensor());
            device.addSensor(relayOnSensor);
        }
        if (deviceConfiguration instanceof TempSetpointRelayPriorityConfiguration) {
            TempSetpointRelayPriorityConfiguration prioConfig = (TempSetpointRelayPriorityConfiguration)deviceConfiguration;
            PrioritySensor prioSensor = new PrioritySensor(deviceConfiguration.getDeviceID());
            prioSensor.setName(Enumerations.SensorName.Priority.getSensorName());
            prioSensor.setSensorID(prioConfig.getPrioritySensorId());
            prioSensor.setState(prioConfig.getPriorityState());
            device.addSensor(prioSensor);
        }
        if (deviceConfiguration instanceof TempSetpointRelayPriorityErrorDeviceConfiguration) {
            TempSetpointRelayPriorityErrorDeviceConfiguration errDevConfig = (TempSetpointRelayPriorityErrorDeviceConfiguration)deviceConfiguration;
            ErrorDetection errorDetection = new ErrorDetection(deviceConfiguration.getDeviceID());
            errorDetection.setName(Enumerations.SensorName.ErrorDetection.getSensorName());
            errorDetection.setSensorID(errDevConfig.getErrorModeSensorId());
            errorDetection.setState(errDevConfig.getErrorDetectionState());
            device.addSensor(errorDetection);
        }
        return device;
    }

    protected Device createTempSetPointPriority(TempSetPointPriorityConfiguration deviceConfiguration) {
        Device device = this.createTempSetPoint(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createTempSetPointPriorityPercentage(TempSetPointPriorityPercentageConfiguration deviceConfiguration) {
        Device device = this.createTempSetPointPriority(deviceConfiguration);
        ValueSensor percentage = new ValueSensor(device.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Value, deviceConfiguration.getPercentageSensorId(), deviceConfiguration.getPercentageValueSettings(), percentage);
        device.addSensor(percentage);
        return device;
    }

    protected Device createTempSetPointVoltage(TempSetPointVoltageConfiguration deviceConfiguration) {
        Device device = this.createGenericTemperature(deviceConfiguration);
        SetPointSensor sensor = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getVoltageValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempHumidity(TempHumidityConfiguration deviceConfiguration) {
        Device device = this.createGenericTemperature(deviceConfiguration);
        HumintySensor sensor = new HumintySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Humidity, deviceConfiguration.getHumiditySensorId(), deviceConfiguration.getHumidityValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempDetection(TempDetectionConfiguration deviceConfiguration) {
        DetectionSensor sensor;
        Device device = this.createGenericTemperature(deviceConfiguration);
        switch (deviceConfiguration.getDetectionSensorType()) {
            case EMPTY: {
                sensor = new EmptyDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case HEATING: {
                sensor = new HeatingDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case HEAT: {
                sensor = new HeatDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case LECKAGE: {
                sensor = new LeckageDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MANOMETER_SETPOINT: {
                sensor = new ManometerSetpointDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MIN: {
                sensor = new MinDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MOISTURE: {
                sensor = new MoistureDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case MOTION: {
                sensor = new MotionDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case OCCUPANCY: {
                sensor = new OccupancyDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case PRESENCE: {
                sensor = new PresenceDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case RAIN: {
                sensor = new RainDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case VOLTAGE: {
                sensor = new VoltageDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case WATER: {
                sensor = new WaterDetection(deviceConfiguration.getDeviceID());
                break;
            }
            case SMOKE: {
                sensor = new SmokeDetection(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new DetectionSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getDetectionSensorType().getParent(), deviceConfiguration.getDetectionSensorId(), deviceConfiguration.getDetectionCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempCO2Humidity(TempCO2HumidityConfiguration deviceConfiguration) {
        Device device = this.createTempCO2(deviceConfiguration);
        HumintySensor sensor = new HumintySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Humidity, deviceConfiguration.getHumiditySensorId(), deviceConfiguration.getHumidityValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createTempCO2(TempCO2Configuration deviceConfiguration) {
        Device device = this.createGenericTemperature(deviceConfiguration);
        CO2Sensor sensor = new CO2Sensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.CO2, deviceConfiguration.getCo2SensorId(), deviceConfiguration.getCo2ValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

