/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.pressed;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.ButtonSensor;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.pressed.configuration.PressedPriorityConfiguration;

public class PressedFactory
extends DeviceFactory {
    private static PressedFactory defaultFactory = null;

    public static PressedFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = PressedFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(PressedFactory factory) {
        defaultFactory = factory;
    }

    public static PressedFactory createDefaultFactory() {
        return new PressedFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return PressedFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case PressedPriority: {
                return this.createPressedPriority((PressedPriorityConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createPressedPriority(PressedPriorityConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        ButtonSensor button = new ButtonSensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Button, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), button);
        device.addSensor(button);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        device.setDeviceType(Enumerations.DeviceType.UNKNOWN);
        return device;
    }
}

