/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.pc;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.UpSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.pc.configuration.GenericPCConfiguration;

public class PCFactory
extends DeviceFactory {
    private static PCFactory defaultFactory = null;

    public static PCFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = PCFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(PCFactory factory) {
        defaultFactory = factory;
    }

    public static PCFactory createDefaultFactory() {
        return new PCFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return PCFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case PC: 
            case PCGroup: {
                return this.createGenericPCDevice((GenericPCConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericPCDevice(GenericPCConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        UpSensor sensor = new UpSensor(deviceConfiguration.getDeviceID());
        sensor.setName("UpSensor");
        sensor.setSensorID(deviceConfiguration.getSensorId());
        sensor.setState((UpSensor.State)((Object)deviceConfiguration.getCurrentState()));
        device.addSensor(sensor);
        return device;
    }
}

