/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.gas;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.LedSensor;
import bsc.api.modules.core.model.sensor.value.GasSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.gas.configuration.GenericGasConfiguration;
import bsc.sdk.api.objects.device.type.gas.configuration.LED_GasConfiguration;

public class GasFactory
extends DeviceFactory {
    private static GasFactory defaultFactory = null;

    public static GasFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = GasFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(GasFactory factory) {
        defaultFactory = factory;
    }

    public static GasFactory createDefaultFactory() {
        return new GasFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return GasFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericGas: {
                return this.createGenericGas((GenericGasConfiguration)deviceConfiguration);
            }
            case GasLed: {
                return this.createGasLed((LED_GasConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericGas(GenericGasConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        GasSensor sensor = new GasSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGasLed(LED_GasConfiguration deviceConfiguration) {
        Device device = this.createGenericGas(deviceConfiguration);
        LedSensor sensor = new LedSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.LedSensor, deviceConfiguration.getLedSensorID(), deviceConfiguration.getLedSensorState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

