/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.eltako;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.CheckSensor;
import bsc.api.modules.core.model.sensor.value.DateTime;
import bsc.api.modules.core.model.sensor.value.ValueSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.eltako.configuration.FGSM14Configuration;

public class EltakoFactory
extends DeviceFactory {
    private static EltakoFactory defaultFactory = null;

    public static EltakoFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = EltakoFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(EltakoFactory factory) {
        defaultFactory = factory;
    }

    public static EltakoFactory createDefaultFactory() {
        return new EltakoFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return EltakoFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case FGSM14: {
                return this.createFGSM14((FGSM14Configuration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createFGSM14(FGSM14Configuration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        CheckSensor sensor = new CheckSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Modem, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        DateTime lc = new DateTime(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.LastConnect, deviceConfiguration.getLastConnectSensorId(), deviceConfiguration.getLastConnectValueSettings(), lc);
        device.addSensor(lc);
        DateTime ld = new DateTime(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.LastDisconnect, deviceConfiguration.getLastDisconnectSensorId(), deviceConfiguration.getLastDisconnectValueSettings(), ld);
        device.addSensor(ld);
        CheckSensor bus = new CheckSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Bus, deviceConfiguration.getBusSensorId(), deviceConfiguration.getBusCurrentState(), bus);
        device.addSensor(bus);
        ValueSensor rmax = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.RSSIMax, deviceConfiguration.getRssiMaxSensorId(), deviceConfiguration.getRssiMaxValueSettings(), rmax);
        device.addSensor(rmax);
        ValueSensor rmean = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.RSSIMean, deviceConfiguration.getRssiMeanSensorId(), deviceConfiguration.getRssiMeanValueSettings(), rmean);
        device.addSensor(rmean);
        ValueSensor rmin = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.RSSIMin, deviceConfiguration.getRssiMinSensorId(), deviceConfiguration.getRssiMinValueSettings(), rmin);
        device.addSensor(rmin);
        return device;
    }
}

