/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.dimmer;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.detection.ErrorDetection;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.value.ColorTemperatureSensor;
import bsc.api.modules.core.model.sensor.value.DimmerSensor;
import bsc.api.modules.core.model.sensor.value.ValueSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.DimmerPriorityColorTempErrorDetectConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.DimmerPriorityConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.DimmerPriorityLimitMinimumBrightnessConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.GenericDimmerConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.RGBDimmerConfiguration;
import bsc.sdk.api.objects.device.type.dimmer.configuration.WhiteLightDimmerConfiguration;

public class DimmerFactory
extends DeviceFactory {
    private static DimmerFactory defaultFactory = null;

    public static DimmerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = DimmerFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(DimmerFactory factory) {
        defaultFactory = factory;
    }

    public static DimmerFactory createDefaultFactory() {
        return new DimmerFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return DimmerFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericDimmer: {
                return this.createGenericDimmer((GenericDimmerConfiguration)deviceConfiguration);
            }
            case DimmerPriority: {
                return this.createDimmerPriority((DimmerPriorityConfiguration)deviceConfiguration);
            }
            case DimmerPriorityLimitMinimumBrightness: {
                return this.createDimmerLimitMinimumBrightness((DimmerPriorityLimitMinimumBrightnessConfiguration)deviceConfiguration);
            }
            case RGBDimmer: {
                return this.createRGBDimmer((RGBDimmerConfiguration)deviceConfiguration);
            }
            case WhiteLightDimmer: {
                return this.createWhiteLightDimmer((WhiteLightDimmerConfiguration)deviceConfiguration);
            }
            case DimmerPriorityColorTemperature: {
                return this.createDimmerPriorityColorTemperature((DimmerPriorityColorTempErrorDetectConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private ADevice createDimmerPriorityColorTemperature(DimmerPriorityColorTempErrorDetectConfiguration deviceConfiguration) {
        Device device = this.createDimmerPriority(deviceConfiguration);
        ColorTemperatureSensor colorSensor = new ColorTemperatureSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ColorTemperature, deviceConfiguration.getColorTempId(), deviceConfiguration.getColorTempSetting(), colorSensor);
        device.addSensor(colorSensor);
        ErrorDetection errorDetection = new ErrorDetection(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.ErrorDetection, deviceConfiguration.getErrorModeSensorId(), deviceConfiguration.getErrorDetectionState(), errorDetection);
        device.addSensor(errorDetection);
        return device;
    }

    private Device createWhiteLightDimmer(WhiteLightDimmerConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        ValueSensor warmWhite = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ValueWarmWhite, deviceConfiguration.getDimmerWarmWhiteSensorId(), deviceConfiguration.getDimmerWarmWhiteSettings(), warmWhite);
        device.addSensor(warmWhite);
        ValueSensor coldWhite = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ValueColdWhite, deviceConfiguration.getDimmerColdWhiteSensorId(), deviceConfiguration.getDimmerColdWhiteSettings(), coldWhite);
        device.addSensor(coldWhite);
        return device;
    }

    protected Device createRGBDimmer(RGBDimmerConfiguration deviceConfiguration) {
        Device device = this.createGenericDimmer(deviceConfiguration);
        ValueSensor red = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ValueRed, deviceConfiguration.getDimmerRedSensorId(), deviceConfiguration.getDimmerRedValueSettings(), red);
        device.addSensor(red);
        ValueSensor green = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ValueGreen, deviceConfiguration.getDimmerGreenSensorId(), deviceConfiguration.getDimmerGreenValueSettings(), green);
        device.addSensor(green);
        ValueSensor blue = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.ValueBlue, deviceConfiguration.getDimmerBlueSensorId(), deviceConfiguration.getDimmerBlueValueSettings(), blue);
        device.addSensor(blue);
        return device;
    }

    protected Device createDimmerLimitMinimumBrightness(DimmerPriorityLimitMinimumBrightnessConfiguration deviceConfiguration) {
        Device device = this.createDimmerPriority(deviceConfiguration);
        OnSensor sensor = new OnSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.On, deviceConfiguration.getLimitMinimumBrightnessSensorId(), deviceConfiguration.getLimitMinimumBrightnessState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createDimmerPriority(DimmerPriorityConfiguration deviceConfiguration) {
        Device device = this.createGenericDimmer(deviceConfiguration);
        PrioritySensor sensor = new PrioritySensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericDimmer(GenericDimmerConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        DimmerSensor sensor = new DimmerSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Dimmer, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

