/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.camera;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.camera.model.Camera;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.detection.MotionDetection;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.camera.configuration.CameraConfiguration;

public class CameraFactory
extends DeviceFactory {
    private static CameraFactory defaultFactory = null;

    public static CameraFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = CameraFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(CameraFactory factory) {
        defaultFactory = factory;
    }

    public static CameraFactory createDefaultFactory() {
        return new CameraFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return CameraFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case Camera: {
                return this.createCamera((CameraConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private Camera createCamera(CameraConfiguration deviceConfiguration) {
        Camera camera = new Camera(deviceConfiguration.getDeviceID());
        this.fillDevice(deviceConfiguration, camera);
        MotionDetection motion = new MotionDetection(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Detection, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), motion);
        camera.addSensor(motion);
        if (deviceConfiguration.getMotionSettingId() != null) {
            EnabledSensor motionSetting = new EnabledSensor(deviceConfiguration.getDeviceID());
            this.fillStateSensor(Enumerations.SensorName.Enabled, deviceConfiguration.getMotionSettingId(), deviceConfiguration.getMotionSettingCurrentState(), motionSetting);
            camera.addSensor(motionSetting);
        }
        DetectionSensor recording = new DetectionSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Recording, deviceConfiguration.getRecordingId(), deviceConfiguration.getRecordingCurrentState(), recording);
        camera.addSensor(recording);
        if (deviceConfiguration.getRecordSettingId() != null) {
            EnabledSensor recordSetting = new EnabledSensor(deviceConfiguration.getDeviceID());
            this.fillStateSensor(Enumerations.SensorName.RecordingEnabled, deviceConfiguration.getRecordSettingId(), deviceConfiguration.getRecordSettingCurrentState(), recordSetting);
            camera.addSensor(recordSetting);
        }
        return camera;
    }
}

