/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects;

import bsc.api.IApiObject;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.IObjectProcessor;
import bsc.sdk.api.objects.IProcessorExecutor;
import bsc.sdk.api.stats.AStatsCollector;
import bsc.sdk.api.stats.AvarageValue;
import bsc.sdk.api.stats.IValueCollector;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AObjectProcessor
extends AStatsCollector<String, Long>
implements IObjectProcessor {
    private final Environment environment;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final IProcessorExecutor executor;

    public AObjectProcessor(Environment environment, IProcessorExecutor executor) {
        this(environment, executor, false);
    }

    public AObjectProcessor(Environment environment, IProcessorExecutor executor, boolean statsEnabled) {
        super(statsEnabled);
        this.environment = Objects.requireNonNull(environment, "environment must not be null");
        this.executor = Objects.requireNonNull(executor, "executor must not be null!");
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void processObject(UserCredentialIdentifier user, IApiObject object) {
        long start = System.currentTimeMillis();
        this.executor.processObject(user, object);
        this.addValue(user.getFullQualifiedIdentifiableString() + " -> " + object.getClass().getSimpleName(), System.currentTimeMillis() - start);
    }

    @Override
    protected IValueCollector<Long> createNewValueCollector() {
        return new AvarageValue();
    }
}

