/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.handler.object;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.handler.IHandleExecutor;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.ObjectHandlerIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AObjectHandler
implements IObjectHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String extensionID;
    private Environment environment;
    private String handlerID;
    private final IHandleExecutor handleExecutor;

    private AObjectHandler(IHandleExecutor handleExecutor) {
        this.handleExecutor = Objects.requireNonNull(handleExecutor, "handleExecutor must not be null!");
    }

    public AObjectHandler(String extensionID, Environment environment, IHandleExecutor handleExecutor) {
        this(handleExecutor);
        this.init(extensionID, environment);
    }

    public AObjectHandler(Enumerations.EXTENSION_ID extensionID, Environment environment, IHandleExecutor handleExecutor) {
        this(handleExecutor);
        this.init(extensionID.getId(this.getClass()), environment);
    }

    private void init(String extensionID, Environment environment) {
        this.extensionID = extensionID;
        this.environment = environment;
        this.handlerID = environment.getHandleManager().getUniqueHandlerID();
    }

    @Override
    public String getExtensionID() {
        return this.extensionID;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getHandlerID() {
        return this.handlerID;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ObjectHandlerIdentifier.generateURI(this.handlerID, applicationID, host);
    }

    @Override
    public URI getURI() {
        return this.getURI(this.getEnvironment().getApplicationId(), this.getEnvironment().getHostID());
    }

    protected void publishObject(Enum<?> tag, Object object) {
        this.environment.getApplication().publishObject(tag, object);
    }

    @Override
    public Result doHandle(TransceiverIdentifier identifier, IApiObject object) {
        return this.handleExecutor.doHandle(identifier, object);
    }
}

