/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.handler.command;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.IExtension;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.ISupportedClass;
import bsc.sdk.api.handler.ObjectHandlerIdentifier;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.tools.Tools;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AExecutor<T extends Command>
implements IObjectHandler,
ISupportedClass {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> clazz;
    private Executable<T> executable;
    private String extensionId;
    private Environment environment;
    private String handlerID;

    public AExecutor(Enumerations.EXTENSION_ID extensionId, Executable<T> executable, Environment environment) {
        this(Objects.requireNonNull(extensionId, "extensionId must not be null!").getId(), Objects.requireNonNull(executable, "executable must not be null!"), environment);
    }

    public AExecutor(String extensionId, Executable<T> executable, Environment environment) {
        Class<?> clazz;
        this.environment = environment;
        this.handlerID = environment.getHandleManager().getUniqueHandlerID();
        this.extensionId = Objects.requireNonNull(extensionId, "extensionId must not be null!");
        this.executable = Objects.requireNonNull(executable, "executable must not be null!");
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            this.clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        } else {
            String name = clazz.getSimpleName();
            for (clazz = this.getClass(); !name.contains("$$006") && clazz != Object.class; clazz = clazz.getSuperclass()) {
                name = clazz.getSimpleName();
            }
            if (clazz == Object.class) {
                throw new RuntimeException("Unable to resolve class");
            }
            this.clazz = (Class)Tools.getActualTypeArguments(name)[0];
        }
    }

    @Override
    public boolean isSupported(IApiObject object) {
        return object.getClass().equals(this.clazz);
    }

    @Override
    public Result doHandle(TransceiverIdentifier identifier, IApiObject object) {
        return this.execute(identifier, (Command)this.clazz.cast(object));
    }

    public Class<T> getSupportedClass() {
        return this.clazz;
    }

    public Result execute(TransceiverIdentifier identifier, T command) {
        this.logger.trace("Execute: " + this.executable.getClass().getName());
        return this.executable.execute(identifier, command);
    }

    protected IExtension getExtension() {
        return this.getEnvironment().getExtensionManager().getExtension(this.getExtensionID());
    }

    @Override
    public String getExtensionID() {
        return this.extensionId;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    protected TransceiverController getTransceiverController(TransceiverIdentifier identifier) {
        return this.getEnvironment().getTransceiverManager().getTransceiverControllerInstance(identifier);
    }

    @Override
    public String getHandlerID() {
        return this.handlerID;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ObjectHandlerIdentifier.generateURI(this.handlerID, applicationID, host);
    }

    @Override
    public URI getURI() {
        return this.getURI(this.getEnvironment().getApplicationId(), this.getEnvironment().getHostID());
    }
}

