/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.vdevice.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.vdevice.commands.offer.CreateVirtualDeviceOffer;
import bsc.api.modules.vdevice.commands.offer.CreateVirtualSensorOffer;
import bsc.api.modules.vdevice.commands.offer.GetVirtualDevicesOffers;
import bsc.api.modules.vdevice.commands.offer.RemoveVirtualSensorOffer;
import bsc.api.modules.vdevice.model.IVirtualDevice;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.vdevice.notification.AVDeviceNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AVDeviceNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> permissions = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (permissions.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new CreateVirtualDeviceOffer());
                }
                if (permissions.contains((Object)Permission.VIEW)) {
                    device.addCommandOffer(new GetVirtualDevicesOffers());
                }
            } else if (device instanceof IVirtualDevice && permissions.contains((Object)Permission.CONFIGURE)) {
                device.addCommandOffer(new CreateVirtualSensorOffer());
                device.addCommandOffer(new RemoveVirtualSensorOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

