/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.usermanagement.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.usermanagement.commands.offer.AddUserOffer;
import bsc.api.modules.usermanagement.commands.offer.ChangeEmailOffer;
import bsc.api.modules.usermanagement.commands.offer.ChangePasswordOffer;
import bsc.api.modules.usermanagement.commands.offer.DeleteUserOffer;
import bsc.api.modules.usermanagement.commands.offer.EnableEmailMessagesOffer;
import bsc.api.modules.usermanagement.commands.offer.EnablePushMessagesOffer;
import bsc.api.modules.usermanagement.commands.offer.GetUsersOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.usermanagement.notification.AUserManagementNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AUserManagementNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new AddUserOffer());
                    device.addCommandOffer(new GetUsersOffer());
                    device.addCommandOffer(new ChangePasswordOffer());
                    device.addCommandOffer(new ChangeEmailOffer());
                    device.addCommandOffer(new EnablePushMessagesOffer());
                    device.addCommandOffer(new EnableEmailMessagesOffer());
                }
                if (rights.contains((Object)Permission.DELETE)) {
                    device.addCommandOffer(new DeleteUserOffer());
                }
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

