/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.usergroupmanagement.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.usergroupmanagement.commands.offer.CreateUserGroupOffer;
import bsc.api.modules.usergroupmanagement.commands.offer.DeleteUserGroupOffer;
import bsc.api.modules.usergroupmanagement.commands.offer.GetAllUserGroupsOffer;
import bsc.api.modules.usergroupmanagement.commands.offer.GetUserGroupPermissionsOffer;
import bsc.api.modules.usergroupmanagement.commands.offer.SetUserGroupsForUserOffer;
import bsc.api.modules.usergroupmanagement.commands.offer.UpdateUserGroupPermissionsOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.usergroupmanagement.notification.AUserGroupManagementNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AUserGroupManagementNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.VIEW)) {
                    device.addCommandOffer(new GetAllUserGroupsOffer());
                }
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new CreateUserGroupOffer());
                    device.addCommandOffer(new GetUserGroupPermissionsOffer());
                    device.addCommandOffer(new UpdateUserGroupPermissionsOffer());
                    device.addCommandOffer(new SetUserGroupsForUserOffer());
                }
                if (rights.contains((Object)Permission.DELETE)) {
                    device.addCommandOffer(new DeleteUserGroupOffer());
                }
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

