/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.notification;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.teachin.commands.offer.AddGatewayOffer;
import bsc.api.modules.teachin.commands.offer.AssignAcknowledgeSignalOffer;
import bsc.api.modules.teachin.commands.offer.CreateDeviceOffer;
import bsc.api.modules.teachin.commands.offer.CreateGroupOffer;
import bsc.api.modules.teachin.commands.offer.DeleteDeviceOffer;
import bsc.api.modules.teachin.commands.offer.DeleteGroupOffer;
import bsc.api.modules.teachin.commands.offer.DiscoverDevicesOffer;
import bsc.api.modules.teachin.commands.offer.GetGatewayDevicesOffer;
import bsc.api.modules.teachin.commands.offer.GetGatewaysOffer;
import bsc.api.modules.teachin.commands.offer.GetPossibleGatewaysOffer;
import bsc.api.modules.teachin.commands.offer.GetSupportedDevicesOffer;
import bsc.api.modules.teachin.commands.offer.LockTeachinOffer;
import bsc.api.modules.teachin.commands.offer.MoveDeviceOffer;
import bsc.api.modules.teachin.commands.offer.MoveGroupOffer;
import bsc.api.modules.teachin.commands.offer.RenameGroupOffer;
import bsc.api.modules.teachin.commands.offer.SendTeachInSignalOffer;
import bsc.api.modules.teachin.commands.offer.StartSignalListeningOffer;
import bsc.api.modules.teachin.commands.offer.StopSignalListeningOffer;
import bsc.api.modules.teachin.commands.offer.UnlockTeachinOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.teachin.notification.ATeachInNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.Arrays;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends ATeachInNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new CreateDeviceOffer());
                    device.addCommandOffer(new GetPossibleGatewaysOffer());
                    device.addCommandOffer(new AddGatewayOffer());
                    device.addCommandOffer(new GetGatewaysOffer());
                    device.addCommandOffer(new GetGatewayDevicesOffer());
                    device.addCommandOffer(new GetSupportedDevicesOffer());
                    device.addCommandOffer(new StartSignalListeningOffer());
                    device.addCommandOffer(new StopSignalListeningOffer());
                    device.addCommandOffer(new CreateGroupOffer());
                    device.addCommandOffer(new MoveGroupOffer());
                    device.addCommandOffer(new RenameGroupOffer());
                    device.addCommandOffer(new MoveDeviceOffer());
                    device.addCommandOffer(new DiscoverDevicesOffer());
                }
                if (rights.contains((Object)Permission.DELETE)) {
                    device.addCommandOffer(new DeleteDeviceOffer());
                    device.addCommandOffer(new DeleteGroupOffer());
                }
            } else {
                if (rights.contains((Object)Permission.DELETE)) {
                    device.addCommandOffer(new DeleteDeviceOffer());
                }
                if (rights.contains((Object)Permission.CONFIGURE) && !device.getDeviceType().equals((Object)Enumerations.DeviceType.Camera) && !device.getDeviceType().equals((Object)Enumerations.DeviceType.Timer) && !device.getDeviceType().equals((Object)Enumerations.DeviceType.UNKNOWN)) {
                    if (device.isActuator()) {
                        device.addCommandOffer(new LockTeachinOffer());
                        device.addCommandOffer(new UnlockTeachinOffer());
                        device.addCommandOffer(new SendTeachInSignalOffer(Arrays.asList("default")));
                    }
                    device.addCommandOffer(new AssignAcknowledgeSignalOffer(Arrays.asList("default")));
                    device.addCommandOffer(new MoveDeviceOffer());
                }
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

