/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.message.command.executor.sensor;

import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.TYPE;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.core.model.sensor.state.StateHelper;
import bsc.api.modules.message.commands.sensor.GetSensorMessagesCommand;
import bsc.api.modules.message.model.container.SensorMessageContainer;
import bsc.api.modules.message.model.sensor.StateSensorMessage;
import bsc.api.modules.message.model.sensor.ValueSensorMessage;
import bsc.api.transport.result.ExceptionResult;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.message.command.AMessageExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.tools.Tools;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public class GetSensorMessagesExecutor
extends AMessageExecutor<GetSensorMessagesCommand> {
    private static Executable<GetSensorMessagesCommand> executable = new Executable<GetSensorMessagesCommand>(){
        private int sensorMessageTypeIndex = 0;
        private final int sensorMessageTypeIndexMax = SensorMessageContainer.MESSAGE_TYPES.values().length;

        @Override
        public Result execute(TransceiverIdentifier identifier, GetSensorMessagesCommand command) {
            SensorIdentifier sensorIdentifier;
            Environment environment = identifier.getEnvironment();
            int maxResults = command.getMaxResults();
            SensorMessageContainer container = new SensorMessageContainer(command.getDeviceID(), command.getSensorID(), TYPE.INCREMENTAL);
            try {
                sensorIdentifier = SensorIdentifier.createIdentifierInstance(command.getDeviceID(), command.getSensorID(), environment);
            }
            catch (URISyntaxException e) {
                return new ExceptionResult(e);
            }
            if (sensorIdentifier == null) {
                return new FailResult("Sensor not found!");
            }
            IIdentifiableApiObject object = sensorIdentifier.getObjectInstance();
            if (object == null) {
                return new FailResult("Sensor not found!");
            }
            if (object instanceof AValueSensor) {
                AValueSensor sensor = (AValueSensor)object;
                Double min = new Double(sensor.getMinValue());
                Double max = new Double(sensor.getMaxValue());
                if (maxResults <= 0) {
                    maxResults = 100;
                    container.setType(TYPE.FULL);
                }
                for (int i = 0; i < maxResults; ++i) {
                    long timestamp = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - (long)(i * 100);
                    double value = Tools.getRandomNumberInRange(min.intValue(), max.intValue());
                    ValueSensorMessage message = new ValueSensorMessage(String.valueOf(i), value, String.valueOf(timestamp), SensorMessageContainer.MESSAGE_TYPES.values()[this.sensorMessageTypeIndex]);
                    ++this.sensorMessageTypeIndex;
                    if (this.sensorMessageTypeIndex == this.sensorMessageTypeIndexMax) {
                        this.sensorMessageTypeIndex = 0;
                    }
                    container.addMessage(message);
                }
            } else if (object instanceof AStateSensor) {
                AStateSensor sensor = (AStateSensor)object;
                for (int i = 0; i < maxResults; ++i) {
                    this.addStateSensorMessage(container, (Enum)sensor.getState(), i);
                }
            }
            this.logger.trace("Execute: " + command.getClass().getName());
            return new ObjectResult(container);
        }

        private <T extends Enum<T>> T addStateSensorMessage(SensorMessageContainer container, T currentState, int index) {
            long timestamp = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - (long)(index * 100);
            StateSensorMessage<T> message = new StateSensorMessage<T>(String.valueOf(index), currentState, String.valueOf(timestamp), SensorMessageContainer.MESSAGE_TYPES.values()[this.sensorMessageTypeIndex]);
            ++this.sensorMessageTypeIndex;
            if (this.sensorMessageTypeIndex == this.sensorMessageTypeIndexMax) {
                this.sensorMessageTypeIndex = 0;
            }
            container.addMessage(message);
            return StateHelper.getNextPossibleStates(currentState).get(0);
        }
    };

    public GetSensorMessagesExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static Executable<GetSensorMessagesCommand> getExecutable() {
        return executable;
    }

    public static void setExecutable(Executable<GetSensorMessagesCommand> executable) {
        GetSensorMessagesExecutor.executable = executable;
    }
}

