/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.object;

import bsc.api.IApiObject;
import bsc.api.modules.IModuleClass;
import bsc.sdk.api.transceiver.controller.AObjectValidator;
import bsc.sdk.api.transceiver.controller.ATransceiverController;
import bsc.sdk.api.transceiver.controller.IObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectValidator
extends AObjectValidator {
    private static Logger logger = LoggerFactory.getLogger(ObjectValidator.class);
    private static IObjectValidator executor = new IObjectValidator(){

        @Override
        public boolean validateObject(ATransceiverController controller, IApiObject object) {
            boolean result;
            long start = System.currentTimeMillis();
            logger.trace("Start object validation");
            boolean bl = result = object != null;
            if (result && IModuleClass.class.isAssignableFrom(object.getClass())) {
                String objectExtensionID = controller.getEnvironment().getExtensionManager().getObjectExtensionID((IModuleClass)object);
                result = controller.getEnvironment().getExtensionManager().isSubscribedFor(controller.getTransceiverIdentifier(), objectExtensionID);
            }
            logger.trace("Finished object validation after " + (System.currentTimeMillis() - start) + " ms");
            return result;
        }
    };

    public ObjectValidator() {
        super(executor);
    }

    public static IObjectValidator getExecutor() {
        return executor;
    }

    public static void setExecutor(IObjectValidator executor) {
        ObjectValidator.executor = executor;
    }
}

